"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const bcrypt = require("bcryptjs");
const { v4: uuidv4 } = require("uuid");
async function generateOrderNum(type) {
    try {
        const uuid = uuidv4();
        const base36 = parseInt(uuid.replace(/-/g, ""), 16).toString(36);
        let firstLetter = type === "others" ? "O" : "S";
        const orderNumber = firstLetter + base36.slice(0, 7).toUpperCase();
        const isOrderNumberExists = await strapi.db
            .query("api::order.order")
            .findOne({
            where: { orderId: orderNumber, is_deleted: false },
        });
        if (isOrderNumberExists)
            return await generateOrderNum(type);
        return orderNumber;
    }
    catch (error) {
        console.log("error in generating order number", error);
    }
}
exports.default = strapi_1.factories.createCoreService("api::sponsor.sponsor", ({ strapi }) => ({
    async findExportData() {
        try {
            const data = await strapi.db.query("api::sponsor.sponsor").findMany({
                where: { is_deleted: false },
                orderBy: { id: "desc" },
                populate: true,
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Sponsor data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllSponsors(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const where = {
                is_deleted: false,
                ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                ...(search &&
                    search.trim().length && {
                    $or: [
                        { company_name: { $containsi: search } },
                        { sponsor_id: { $containsi: search } },
                    ],
                }),
            };
            const data = await strapi.db.query("api::sponsor.sponsor").findMany({
                where,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
                populate: true,
            });
            if (data) {
                const totalDataCount = await strapi
                    .query("api::sponsor.sponsor")
                    .count({ where });
                const pageCount = Math.ceil(totalDataCount / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: totalDataCount,
                    },
                }, "Sponsor data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    getByUUID: async (id) => {
        var _a;
        try {
            const sponsor = await strapi.query("api::sponsor.sponsor").findOne({
                where: { sponsor_id: id, is_deleted: false },
                populate: {
                    orderId: true,
                    categories: true,
                    sectors_id: true,
                    ticket_masters: {
                        where: {
                            status: {
                                $notIn: ["deleted", "refunded", "cancelled"]
                            }
                        },
                        populate: {
                            ticket_id: true,
                        },
                    },
                },
            });
            return new dataResponse_dto_1.DataResponseDto(sponsor, "sponsor fetched successfully");
        }
        catch (error) {
            console.log(error);
            if ((_a = error.details) === null || _a === void 0 ? void 0 : _a.errors) {
                return new dataResponse_dto_1.DataResponseDto(null, false, error.details.errors);
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
            }
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db.query("api::sponsor.sponsor").update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "sponsor deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async sponsorLogin(body) {
        try {
            const { sponsorId, password } = body;
            if (!sponsorId || !password) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide valid credentials");
            }
            const sponsor = await strapi.query("api::sponsor.sponsor").findOne({
                where: { sponsor_id: sponsorId, is_deleted: false },
            });
            if (!sponsor) {
                return {
                    data: null,
                    status: false,
                    message: "Sponsor not found.",
                };
            }
            const isPasswordValid = await bcrypt.compare(password, sponsor === null || sponsor === void 0 ? void 0 : sponsor.password);
            if (!isPasswordValid) {
                return {
                    data: null,
                    status: false,
                    message: "Invalid credentials.",
                };
            }
            return new dataResponse_dto_1.DataResponseDto(sponsor, "Sponsor logged in successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    createSponsor: async (body) => {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a;
                if (!body.password) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Password is required");
                }
                if (Number(body === null || body === void 0 ? void 0 : body.executive) < 0 || Number((body === null || body === void 0 ? void 0 : body.delegate) < 0) || Number(body === null || body === void 0 ? void 0 : body.paddock_club) < 0 || Number(body === null || body === void 0 ? void 0 : body.general_admission) < 0
                    || Number(body === null || body === void 0 ? void 0 : body.RESOLVE) < 0 || Number(body === null || body === void 0 ? void 0 : body.Asset_Abu_Dhabi) < 0 || Number(body === null || body === void 0 ? void 0 : body.Fintech_Abu_Dhabi) < 0 ||
                    Number(body === null || body === void 0 ? void 0 : body.ADSFF) < 0 || Number(body === null || body === void 0 ? void 0 : body.single_day_delegate) < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please make sure your limit has at least a value of zero.");
                }
                let generatedOrderNumber = await generateOrderNum("others");
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: generatedOrderNumber,
                        type: body.type,
                        paymentId: null,
                        eventDate: new Date(),
                        firstName: body === null || body === void 0 ? void 0 : body.company_name,
                        lastName: "",
                        email: body === null || body === void 0 ? void 0 : body.email,
                        company: body === null || body === void 0 ? void 0 : body.company_name,
                        sector: body === null || body === void 0 ? void 0 : body.sector,
                        designation: body === null || body === void 0 ? void 0 : body.designation,
                        nationality: body === null || body === void 0 ? void 0 : body.nationality,
                        residanceCountry: body === null || body === void 0 ? void 0 : body.residanceCountry,
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        mobile: body === null || body === void 0 ? void 0 : body.mobile,
                        photo: body === null || body === void 0 ? void 0 : body.photo,
                        ticketCount: (body === null || body === void 0 ? void 0 : body.ticketCount) || 0,
                        discountAmount: body === null || body === void 0 ? void 0 : body.discountAmount,
                        totalAmount: body === null || body === void 0 ? void 0 : body.totalAmount,
                        paidAmount: body === null || body === void 0 ? void 0 : body.totalAmount,
                        is_discounted: body === null || body === void 0 ? void 0 : body.is_discounted,
                        publishedAt: new Date(),
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Free",
                        userType: "sponsor",
                        creator: body === null || body === void 0 ? void 0 : body.userId
                    },
                    transacting: trx,
                });
                let hashPassword = await bcrypt.hash((_a = body === null || body === void 0 ? void 0 : body.password) === null || _a === void 0 ? void 0 : _a.toString().trim(), 10);
                let generatedSponsorNumber = await generateOrderNum("sponsor");
                let sponsor = {
                    company_name: body === null || body === void 0 ? void 0 : body.company_name,
                    horizontal_logo: body === null || body === void 0 ? void 0 : body.horizontal_logo,
                    vertical_logo: body === null || body === void 0 ? void 0 : body.vertical_logo,
                    orderId: order === null || order === void 0 ? void 0 : order.id,
                    sponsor_id: generatedSponsorNumber,
                    executive: (body === null || body === void 0 ? void 0 : body.executive) || 0,
                    delegate: (body === null || body === void 0 ? void 0 : body.delegate) || 0,
                    paddock_club: (body === null || body === void 0 ? void 0 : body.paddock_club) || 0,
                    general_admission: (body === null || body === void 0 ? void 0 : body.general_admission) || 0,
                    RESOLVE: (body === null || body === void 0 ? void 0 : body.RESOLVE) || 0,
                    Asset_Abu_Dhabi: (body === null || body === void 0 ? void 0 : body.Asset_Abu_Dhabi) || 0,
                    Fintech_Abu_Dhabi: (body === null || body === void 0 ? void 0 : body.Fintech_Abu_Dhabi) || 0,
                    ADSFF: (body === null || body === void 0 ? void 0 : body.ADSFF) || 0,
                    single_day_delegate: (body === null || body === void 0 ? void 0 : body.single_day_delegate) || 0,
                    remaining_single_day_delegate_count: (body === null || body === void 0 ? void 0 : body.single_day_delegate) || 0,
                    remaining_executive_count: (body === null || body === void 0 ? void 0 : body.executive) || 0,
                    remaining_delegate_count: (body === null || body === void 0 ? void 0 : body.delegate) || 0,
                    remaining_padock_club_count: (body === null || body === void 0 ? void 0 : body.paddock_club) || 0,
                    remaining_general_admission_count: (body === null || body === void 0 ? void 0 : body.general_admission) || 0,
                    remaining_resolve_count: (body === null || body === void 0 ? void 0 : body.RESOLVE) || 0,
                    remaining_asset_abu_dhabi_count: (body === null || body === void 0 ? void 0 : body.Asset_Abu_Dhabi) || 0,
                    remaining_fintech_abu_dhabi_count: (body === null || body === void 0 ? void 0 : body.Fintech_Abu_Dhabi) || 0,
                    remaining_adsff_count: (body === null || body === void 0 ? void 0 : body.ADSFF) || 0,
                    categories: body === null || body === void 0 ? void 0 : body.categories,
                    video_link: body === null || body === void 0 ? void 0 : body.video_link,
                    video_file_link: body === null || body === void 0 ? void 0 : body.video_file_link,
                    contact_person_country_code: body === null || body === void 0 ? void 0 : body.contact_person_country_code,
                    is_deleted: false,
                    password: hashPassword,
                    publishedAt: new Date(),
                    websiteImage: body === null || body === void 0 ? void 0 : body.websiteImage,
                    priority: body === null || body === void 0 ? void 0 : body.priority,
                    showInWebsite: body === null || body === void 0 ? void 0 : body.showInWebsite,
                    creator: body === null || body === void 0 ? void 0 : body.userId
                };
                const sponsorData = await strapi.entityService.create("api::sponsor.sponsor", {
                    data: sponsor,
                    transacting: trx,
                });
                let res = {
                    order,
                    sponsorData,
                };
                return new dataResponse_dto_1.DataResponseDto(res, "Order Created successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    updateSponsor: async (id, body) => {
        try {
            const existingSponsor = await strapi.db
                .query("api::sponsor.sponsor")
                .findOne({
                where: { id },
            });
            if (!existingSponsor) {
                return new dataResponse_dto_1.DataResponseDto(null, "Sponsor not found");
            }
            const order = await strapi.db.query("api::order.order").update({
                where: { orderId: body.orderId },
                data: {
                    firstName: body === null || body === void 0 ? void 0 : body.company_name,
                    lastName: "",
                    email: body === null || body === void 0 ? void 0 : body.contact_person_email,
                    company: body === null || body === void 0 ? void 0 : body.company_name,
                    sector: body === null || body === void 0 ? void 0 : body.sectors_id,
                    designation: body === null || body === void 0 ? void 0 : body.contact_person_designation,
                    mobile: body === null || body === void 0 ? void 0 : body.contact_person_phone,
                },
            });
            let executiveCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.executive;
            let delegateCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.delegate;
            let general_admissionCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.general_admission;
            let single_day_delegateCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.single_day_delegate;
            let resolveCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.RESOLVE;
            let assetCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.Asset_Abu_Dhabi;
            let fintechCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.Fintech_Abu_Dhabi;
            let adsffCount = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.ADSFF;
            let paddock_club = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.paddock_club;
            let remaining_executive_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_executive_count) || 0;
            let remaining_delegate_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_delegate_count) || 0;
            let remaining_padock_club_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_padock_club_count) || 0;
            let remaining_general_admission_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_general_admission_count) || 0;
            let remaining_single_day_delegate_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_single_day_delegate_count) || 0;
            let remaining_resolve_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_resolve_count) || 0;
            let remaining_asset_abu_dhabi_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_asset_abu_dhabi_count) || 0;
            let remaining_fintech_abu_dhabi_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_fintech_abu_dhabi_count) || 0;
            let remaining_adsff_count = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_adsff_count) || 0;
            // exective
            if (body.executive === 0 || body.executive) {
                executiveCount = body.executive === 0 ? 0 : body.executive;
                const executive_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.executive) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_executive_count);
                if (Number(executive_remaining) > Number(executiveCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "executive cannot be less than redeemed tickets count");
                }
                remaining_executive_count =
                    Number(executiveCount) - Number(executive_remaining);
            }
            // full week
            if (body.delegate === 0 || body.delegate) {
                delegateCount = body.delegate === 0 ? 0 : body.delegate;
                let delegate_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.delegate) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_delegate_count);
                if (Number(delegate_remaining) > Number(delegateCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total full week count cannot be less than redeemed tickets count");
                }
                remaining_delegate_count =
                    Number(delegateCount) - Number(delegate_remaining);
            }
            // padock_club
            if (body.padock_club === 0 || body.padock_club) {
                paddock_club = body.padock_club === 0 ? 0 : body.padock_club;
                let padock_club_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.padock_club) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_padock_club_count);
                if (Number(padock_club_remaining) > Number(paddock_club)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total padock_club count cannot be less than redeemed tickets count");
                }
                remaining_padock_club_count =
                    Number(paddock_club) - Number(padock_club_remaining);
            }
            // general_admission
            if (body.general_admission === 0 || body.general_admission) {
                general_admissionCount = body.general_admission === 0 ? 0 : body.general_admission;
                let general_admission_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.general_admission) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_general_admission_count);
                if (Number(general_admission_remaining) > Number(general_admissionCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total general_admission count cannot be less than redeemed tickets count");
                }
                remaining_general_admission_count =
                    Number(general_admissionCount) -
                        Number(general_admission_remaining);
            }
            // single_day_delegate
            if (body.single_day_delegate === 0 || body.single_day_delegate) {
                single_day_delegateCount = body.single_day_delegate === 0 ? 0 : body.single_day_delegate;
                let single_day_delegate_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.single_day_delegate) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_single_day_delegate_count);
                if (Number(single_day_delegate_remaining) >
                    Number(single_day_delegateCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total single_day_delegate count cannot be less than redeemed tickets count");
                }
                remaining_single_day_delegate_count =
                    Number(single_day_delegateCount) -
                        Number(single_day_delegate_remaining);
            }
            // resolve done
            if (body.RESOLVE === 0 || body.RESOLVE) {
                resolveCount = body.RESOLVE === 0 ? 0 : body.RESOLVE;
                let resolve_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.RESOLVE) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_resolve_count);
                if (Number(resolve_remaining) > Number(resolveCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total resolve count cannot be less than redeemed tickets count");
                }
                remaining_resolve_count =
                    Number(resolveCount) - Number(resolve_remaining);
            }
            // asset_abu_dhabi
            if (body.Asset_Abu_Dhabi === 0 || body.Asset_Abu_Dhabi) {
                assetCount = body.Asset_Abu_Dhabi === 0 ? 0 : body.Asset_Abu_Dhabi;
                let asset_abu_dhabi_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.Asset_Abu_Dhabi) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_asset_abu_dhabi_count);
                if (Number(asset_abu_dhabi_remaining) > Number(assetCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total asset_abu_dhabi count cannot be less than redeemed tickets count");
                }
                remaining_asset_abu_dhabi_count =
                    Number(assetCount) - Number(asset_abu_dhabi_remaining);
            }
            // fintech_abu_dhabi
            if (body.Fintech_Abu_Dhabi === 0 || body.Fintech_Abu_Dhabi) {
                fintechCount = body.Fintech_Abu_Dhabi === 0 ? 0 : body.Fintech_Abu_Dhabi;
                let fintech_abu_dhabi_remaining = Number(existingSponsor.Fintech_Abu_Dhabi) -
                    Number(existingSponsor.remaining_fintech_abu_dhabi_count);
                if (Number(fintech_abu_dhabi_remaining) > Number(fintechCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total fintech_abu_dhabi count cannot be less than redeemed tickets count");
                }
                remaining_fintech_abu_dhabi_count =
                    Number(fintechCount) -
                        Number(fintech_abu_dhabi_remaining);
            }
            // adsff
            if (body.ADSFF === 0 || body.ADSFF) {
                adsffCount = body.ADSFF === 0 ? 0 : body.ADSFF;
                let adsff_remaining = Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.ADSFF) -
                    Number(existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.remaining_adsff_count);
                if (Number(adsff_remaining) > Number(adsffCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total adsff count cannot be less than redeemed tickets count");
                }
                remaining_adsff_count =
                    Number(adsffCount) - Number(adsff_remaining);
            }
            // hash new password
            let password = existingSponsor === null || existingSponsor === void 0 ? void 0 : existingSponsor.password;
            if (body.password) {
                password = await bcrypt.hash(body.password.toString().trim(), 10);
            }
            const dataObj = {
                password: password,
                company_name: body === null || body === void 0 ? void 0 : body.company_name,
                horizontal_logo: body === null || body === void 0 ? void 0 : body.horizontal_logo,
                vertical_logo: body === null || body === void 0 ? void 0 : body.vertical_logo,
                brand_guidlinesImage: body === null || body === void 0 ? void 0 : body.brand_guidlinesImage,
                sectors_id: body === null || body === void 0 ? void 0 : body.sectors_id,
                company_url: body === null || body === void 0 ? void 0 : body.company_url,
                company_brief: body === null || body === void 0 ? void 0 : body.company_brief,
                contact_person_name: body === null || body === void 0 ? void 0 : body.contact_person_name,
                contact_person_email: body === null || body === void 0 ? void 0 : body.contact_person_email,
                contact_person_phone: body === null || body === void 0 ? void 0 : body.contact_person_phone,
                contact_person_designation: body === null || body === void 0 ? void 0 : body.contact_person_designation,
                executive: Number(executiveCount),
                delegate: Number(delegateCount),
                single_day_delegate: Number(single_day_delegateCount),
                paddock_club: Number(paddock_club),
                general_admission: Number(general_admissionCount),
                RESOLVE: Number(resolveCount),
                Asset_Abu_Dhabi: Number(assetCount),
                Fintech_Abu_Dhabi: Number(fintechCount),
                ADSFF: Number(adsffCount),
                remaining_executive_count: Number(remaining_executive_count),
                remaining_delegate_count: Number(remaining_delegate_count),
                remaining_padock_club_count: Number(remaining_padock_club_count),
                remaining_general_admission_count: Number(remaining_general_admission_count),
                remaining_resolve_count: Number(remaining_resolve_count),
                remaining_asset_abu_dhabi_count: Number(remaining_asset_abu_dhabi_count),
                remaining_fintech_abu_dhabi_count: Number(remaining_fintech_abu_dhabi_count),
                remaining_adsff_count: Number(remaining_adsff_count),
                remaining_single_day_delegate_count: Number(remaining_single_day_delegate_count),
                categories: body === null || body === void 0 ? void 0 : body.categories,
                isEdited: body === null || body === void 0 ? void 0 : body.isEdited,
                video_link: body === null || body === void 0 ? void 0 : body.video_link,
                video_file_link: body === null || body === void 0 ? void 0 : body.video_file_link,
                contact_person_country_code: body === null || body === void 0 ? void 0 : body.contact_person_country_code,
                websiteImage: body === null || body === void 0 ? void 0 : body.websiteImage,
                priority: body === null || body === void 0 ? void 0 : body.priority,
                showInWebsite: body === null || body === void 0 ? void 0 : body.showInWebsite,
                modifiedBy: body === null || body === void 0 ? void 0 : body.userId
            };
            // update sponsor
            const sponsor = await strapi.db.query("api::sponsor.sponsor").update({
                where: { id },
                data: dataObj,
            });
            let res = {
                order,
                sponsor,
            };
            return new dataResponse_dto_1.DataResponseDto(res, "sponsor Updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    generateOrderNum: async (type) => {
        try {
            const uuid = uuidv4();
            const base36 = parseInt(uuid.replace(/-/g, ""), 16).toString(36);
            let firstLetter = "O";
            const orderNumber = firstLetter + base36.slice(0, 7).toUpperCase();
            const isOrderNumberExists = await strapi.db
                .query("api::order.order")
                .findOne({
                where: { orderId: orderNumber, is_deleted: false },
            });
            if (isOrderNumberExists)
                return await generateOrderNum(type);
            return orderNumber;
        }
        catch (error) {
            console.log("error in generating order number", error);
        }
    }
}));
