"use strict";
/**
 * ticket-benefit controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::ticket-benefit.ticket-benefit", ({ strapi }) => ({
    async createTicketBenefit(ctx, next) {
        try {
            const data = await strapi
                .service("api::ticket-benefit.ticket-benefit")
                .createTicketBenefit(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    checkUniqueConstraint: async (ctx) => {
        try {
            const { badge_category, ticket_type, day } = ctx.request.query;
            if (!badge_category || !ticket_type || !day) {
                return ctx.badRequest("badge_category, ticket_type, and day are required");
            }
            const data = await strapi
                .service("api::ticket-benefit.ticket-benefit")
                .checkUniqueConstraint({
                badge_category,
                ticket_type,
                day,
            });
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllBenefits: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-benefit.ticket-benefit")
                .findAllBenefits(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllBenefitsByTicketNumber: async (ctx) => {
        try {
            const { ticketNumber } = ctx.params;
            if (!ticketNumber) {
                return ctx.badRequest("Ticket Number is required");
            }
            const data = await strapi
                .service("api::ticket-benefit.ticket-benefit")
                .findAllBenefitsByTicketNumber(ticketNumber, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
