"use strict";
/**
 * ticket-benefit router
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::ticket-benefit.ticket-benefit");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/createTicketBenefit",
        handler: "ticket-benefit.createTicketBenefit",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-benefit/validateUnique",
        handler: "ticket-benefit.checkUniqueConstraint",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-benefit/all",
        handler: "ticket-benefit.findAllBenefits",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-benefit/:ticketNumber",
        handler: "ticket-benefit.findAllBenefitsByTicketNumber",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
