"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const onsiteDataTypes_1 = require("../../../shared/helpers/onsiteDataTypes");
const { yup, validateYupSchema } = require('@strapi/utils');
exports.default = strapi_1.factories.createCoreController("api::ticket-master.ticket-master", ({ strapi }) => ({
    async createTicket(ctx, next) {
        var _a;
        try {
            if (((_a = ctx.request.body) === null || _a === void 0 ? void 0 : _a.type) === "myself") {
                const requestSchema = yup.object({
                    firstName: yup.string().required('First name is required'),
                    lastName: yup.string().required('Last name is required'),
                    email: yup.string().email('Invalid email').required('Email is required'),
                    company: yup.string().required('Company is required'),
                    designation: yup.string().required('Designation is required'),
                    nationality: yup.string().required('Nationality is required'),
                    residanceCountry: yup.string().required('Residence country is required'),
                    countryCode: yup.string().required('Country code is required'),
                    mobile: yup.string().required('Mobile is required'),
                    ticketType: yup.string().required('Ticket type is required'),
                    sector: yup.string().required('Sector is required'),
                    photo: yup.string().required('Photo is required'),
                    day: yup.object({
                        event: yup.string().required('Event is required')
                    }).required('Day object is required')
                });
                await validateYupSchema(requestSchema)(ctx.request.body);
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .createTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async createRedeemTicket(ctx, next) {
        try {
            const requestSchema = yup.object({
                orderNumber: yup.string().required('Order number is required'),
                firstName: yup.string().required('First name is required'),
                lastName: yup.string().required('Last name is required'),
                email: yup.string().email('Invalid email').required('Email is required'),
                company: yup.string().required('Company is required'),
                designation: yup.string().required('Designation is required'),
                nationality: yup.string().required('Nationality is required'),
                residanceCountry: yup.string().required('Residence country is required'),
                countryCode: yup.string().required('Country code is required'),
                mobile: yup.string()
                    .matches(/^\+?[\d\s-]+$/, 'Invalid mobile number format')
                    .required('Mobile is required'),
                ticketType: yup.string().required('Ticket type is required'),
                sector: yup.string().required('Sector is required'),
                photo: yup.string().required('Photo is required'),
                day: yup.object({
                    event: yup.string().required('Event is required')
                }).required('Day object is required')
            });
            await validateYupSchema(requestSchema)(ctx.request.body);
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .createRedeemTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadSponsorTicket(ctx, next) {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadSponsorTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadSpeakerTickets(ctx, next) {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadSpeakerTickets(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadAdgmTicket(ctx, next) {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadAdgmTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadUserTickets(ctx, next) {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadUserTickets(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    findAllTickets: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .findAllTickets(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .findExportData(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getTicketDataByOrderNumber: async (ctx) => {
        try {
            const { orderNumber } = ctx.params;
            if (!orderNumber) {
                return ctx.badRequest("Order ID is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .getTicketDataByOrderNumber(orderNumber);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getTicketByTicketNumber: async (ctx) => {
        try {
            const { ticketNumber } = ctx.params;
            const { token } = ctx.request.query;
            if (!ticketNumber) {
                return ctx.badRequest("Ticker is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .getTicketByTicketNumber(ticketNumber, token);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateByTicketNumber: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .updateByTicketNumber(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    issueTicket: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .issueTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    shareTicket: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .shareTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    recieveExistingTicket: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .recieveExistingTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    reAssignTicket: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .reAssignTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            const { userId } = ctx.request.query;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .softDelete(id, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateChatOption: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .updateChatOption(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateTermsAgreed: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .updateTermsAgreed(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    approveTicketByAdmin: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .approveTicketByAdmin(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    uploadVipTickets: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadVipTickets(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    uploadUBSTickets: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .uploadUBSTickets(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateTicketStatus: async (ctx) => {
        try {
            const { status, userId } = ctx.request.body;
            const { ticketNumber } = ctx.params;
            if (!status) {
                return ctx.badRequest("Status is required");
            }
            if (!ticketNumber) {
                return ctx.badRequest("Ticket Number is required");
            }
            // const {userAccess} = ctx.state.user;
            const user = await strapi
                .query("plugin::users-permissions.user")
                .findOne({
                where: { id: userId, is_deleted: false },
            });
            if (!user) {
                return ctx.notFound('User not found');
            }
            const userAccess = user === null || user === void 0 ? void 0 : user.session_access;
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .updateTicketStatus(ticketNumber, status, userAccess, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateBadgeCategoryByTicketNumber: async (ctx) => {
        try {
            const { ticketNumber } = ctx.params;
            if (!ticketNumber) {
                return ctx.badRequest("Ticket Number is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .updateBadgeCategoryByTicketNumber(ticketNumber, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createPrivateEventTicket: async (ctx) => {
        try {
            const requestSchema = yup.object({
                firstName: yup.string().required('First name is required'),
                lastName: yup.string().required('Last name is required'),
                email: yup.string().email('Invalid email').required('Email is required'),
                company: yup.string().required('Company is required'),
                designation: yup.string().required('Designation is required'),
                nationality: yup.string().required('Nationality is required'),
                residanceCountry: yup.string().required('Residence country is required'),
                countryCode: yup.string().required('Country code is required'),
                mobile: yup.string()
                    .matches(/^\+?[\d\s-]+$/, 'Invalid mobile number format')
                    .required('Mobile is required'),
                ticketType: yup.string().required('Ticket type is required'),
                sector: yup.string().required('Industry is required'),
                subSector: yup.string().required('sector is required'),
                photo: yup.string().required('Photo is required'),
                privateAgendaId: yup.number().required('Agenda is required')
            });
            await validateYupSchema(requestSchema)(ctx.request.body);
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .createPrivateEventTicket(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    approvePrivateEventTicket: async (ctx) => {
        try {
            const { userId } = ctx.request.query;
            const { ticketId } = ctx.params;
            if (!ticketId) {
                return ctx.badRequest("Ticket Number is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .approvePrivateEventTicket(ticketId, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createUnsyncOrders: async (ctx) => {
        try {
            const { orderId } = ctx.params;
            if (!orderId) {
                return ctx.badRequest("Order Number is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .createUnsyncOrders(orderId, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    resendEmail: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .resendEmail(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findDuplicateTicketsById: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .findDuplicateTicketsById(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    checkDuplicateTickets: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .checkDuplicateTickets(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    onsiteRegistration: async (ctx) => {
        try {
            let reqObj = ctx.request.body;
            if (!reqObj.photo ||
                !reqObj.firstName ||
                !reqObj.lastName ||
                !reqObj.email ||
                !reqObj.company ||
                !(reqObj === null || reqObj === void 0 ? void 0 : reqObj.ticketNumber) ||
                !reqObj.designation ||
                !Object.values(onsiteDataTypes_1.BadgeCategory).includes(reqObj.badgeCategory) ||
                (reqObj.residanceCountry && !Object.values(onsiteDataTypes_1.Country).includes(reqObj.residanceCountry)) ||
                (reqObj.nationality && !Object.values(onsiteDataTypes_1.Country).includes(reqObj.nationality)) ||
                (reqObj.emirate && !Object.values(onsiteDataTypes_1.Emirate).includes(reqObj.emirate)) ||
                (reqObj.phone && !reqObj.countryCode) || (reqObj.countryCode && !reqObj.phone)) {
                return ctx.badRequest();
            }
            ;
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .onsiteRegistration(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    syncTicketsWithEveno: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .syncTicketsWithEveno(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllDuplicateTickets: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .findAllDuplicateTickets(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    deleteTicketFromEvento: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .deleteTicketFromEvento(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    upgradeTicketStatus: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .upgradeTicketStatus();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findVisitorDetails: async (ctx) => {
        try {
            const { ticketNumber } = ctx.request.query;
            if (!ticketNumber) {
                return ctx.badRequest("Ticket Number is required");
            }
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .findVisitorDetails(ticketNumber);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getToken: async (ctx) => {
        try {
            const data = await strapi
                .service("api::ticket-master.ticket-master")
                .getToken(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
