"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::ticket-master.ticket-master");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/createTicket",
        handler: "ticket-master.createTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/createRedeemTicket",
        handler: "ticket-master.createRedeemTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/uploadSponsorTicket",
        handler: "ticket-master.uploadSponsorTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/uploadAdgmTicket",
        handler: "ticket-master.uploadAdgmTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/importTickets",
        handler: "ticket-master.uploadUserTickets",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/importVipTickets",
        handler: "ticket-master.uploadVipTickets",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-master/all",
        handler: "ticket-master.findAllTickets",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-master/export",
        handler: "ticket-master.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/ticketData/:orderNumber",
        handler: "ticket-master.getTicketDataByOrderNumber",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/ticketNum/:ticketNumber",
        handler: "ticket-master.getTicketByTicketNumber",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/ticket-masters/change/:ticketNumber",
        handler: "ticket-master.updateByTicketNumber",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/share",
        handler: "ticket-master.shareTicket",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/recieve-ticket",
        handler: "ticket-master.recieveExistingTicket",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/issue",
        handler: "ticket-master.issueTicket",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/re-assign",
        handler: "ticket-master.reAssignTicket",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/remove/:id",
        handler: "ticket-master.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/update/allowChat/:id",
        handler: "ticket-master.updateChatOption",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/update-terms/:id",
        handler: "ticket-master.updateTermsAgreed",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/approve",
        handler: "ticket-master.approveTicketByAdmin",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/ticket-masters/updateStatus/:ticketNumber",
        handler: "ticket-master.updateTicketStatus",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/uploadSpeakerTicket",
        handler: "ticket-master.uploadSpeakerTickets",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/uploadUBSSponsorTickets",
        handler: "ticket-master.uploadUBSTickets",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/ticket-masters/updateBadgeCategory/:ticketNumber",
        handler: "ticket-master.updateBadgeCategoryByTicketNumber",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/privateTicket/create",
        handler: "ticket-master.createPrivateEventTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/approve-private-ticket/:ticketId",
        handler: "ticket-master.approvePrivateEventTicket",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/create-unsync-order/:orderId",
        handler: "ticket-master.createUnsyncOrders",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/resend-email",
        handler: "ticket-master.resendEmail",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-masters/find-duplicates/:id",
        handler: "ticket-master.findDuplicateTicketsById",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/ticket-masters/check-duplicates",
        handler: "ticket-master.checkDuplicateTickets",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/adfw2024/onsiteRegistration",
        handler: "ticket-master.onsiteRegistration",
        config: {
            policies: [],
            middlewares: []
        },
    },
    {
        method: "POST",
        path: "/syncTicketsData",
        handler: "ticket-master.syncTicketsWithEveno",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/deleteTicketFromEvento",
        handler: "ticket-master.deleteTicketFromEvento",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-master/duplicatesData/all",
        handler: "ticket-master.findAllDuplicateTickets",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-master/upgradeStatus",
        handler: "ticket-master.upgradeTicketStatus",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/ticket-master/visitorDetails",
        handler: "ticket-master.findVisitorDetails",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/getToken",
        handler: "ticket-master.getToken",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
