"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const moment_1 = __importDefault(require("moment"));
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const constants_1 = require("../../../shared/helpers/constants");
const generateTicketNumbers_1 = require("../../../shared/helpers/generateTicketNumbers");
const onsiteDataTypes_1 = require("../../../shared/helpers/onsiteDataTypes");
const axios = require("axios");
const jwt = require("jsonwebtoken");
const { v4: uuidv4 } = require("uuid");
async function generateTicketNum(letter) {
    var _a;
    try {
        const uuid = uuidv4();
        const sixDigitUUID = (_a = uuid.replace(/-/g, "").slice(0, 6)) === null || _a === void 0 ? void 0 : _a.toUpperCase();
        const ticketNumber = letter + sixDigitUUID;
        const isTicketExists = await strapi.db
            .query("api::ticket-master.ticket-master")
            .findOne({
            where: { ticketNumber: ticketNumber, is_deleted: false },
        });
        if (isTicketExists)
            return await generateTicketNum(letter);
        return ticketNumber;
    }
    catch (error) {
        console.log("error in generating ticket number", error);
    }
}
async function generateOrderNum(type) {
    try {
        const uuid = uuidv4();
        const base36 = parseInt(uuid.replace(/-/g, ""), 16).toString(36);
        let firstLetter = type === "others" ? "O" : "S";
        const orderNumber = firstLetter + base36.slice(0, 7).toUpperCase();
        const isOrderNumberExists = await strapi.db
            .query("api::order.order")
            .findOne({
            where: { orderId: orderNumber, is_deleted: false },
        });
        if (isOrderNumberExists)
            return await generateOrderNum(type);
        return orderNumber;
    }
    catch (error) {
        console.log("error in generating order number", error);
    }
}
exports.default = strapi_1.factories.createCoreService("api::ticket-master.ticket-master", ({ strapi }) => ({
    createTicket: async (body) => {
        var _a;
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1;
                const decode = jwt.decode(body.token, process.env.EVENTO_JWT_SECRET);
                if (!decode) {
                    return {
                        data: null,
                        status: false,
                        errorCode: "ERROD002",
                        message: "Invalid token",
                    };
                }
                const isOrderExists = await strapi.db
                    .query("api::order.order")
                    .findOne({
                    where: { orderId: decode === null || decode === void 0 ? void 0 : decode.identifier, is_deleted: false },
                    populate: {
                        ticket_masters: {
                            populate: {
                                ticket_id: {
                                    select: ["title", "id_short"],
                                },
                            },
                        },
                    },
                });
                if (isOrderExists) {
                    return {
                        data: isOrderExists,
                        status: false,
                        errorCode: "ERROD001",
                        message: "Order already exists",
                    };
                }
                const existingOrderLog = await strapi
                    .query("api::payment-log.payment-log")
                    .findOne({
                    where: { orderId: decode.identifier, status: "pending" },
                });
                if (!existingOrderLog)
                    return {
                        data: null,
                        status: false,
                        message: "There is no active reference for this order number",
                        errorCode: "ERROD009",
                    };
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: decode.identifier,
                        type: body.type,
                        paymentId: null,
                        eventDate: new Date(),
                        firstName: body.firstName,
                        lastName: body.lastName,
                        email: body.email,
                        company: body.company,
                        sector: body.sector,
                        designation: body.designation,
                        nationality: body.nationality,
                        residanceCountry: body.residanceCountry,
                        countryCode: body.countryCode,
                        mobile: body.mobile,
                        photo: body.photo,
                        ticketCount: body === null || body === void 0 ? void 0 : body.ticketCount,
                        discountAmount: body === null || body === void 0 ? void 0 : body.discountAmount,
                        discountCode: body === null || body === void 0 ? void 0 : body.discountId,
                        totalAmount: body === null || body === void 0 ? void 0 : body.totalAmount,
                        paidAmount: body === null || body === void 0 ? void 0 : body.totalAmount,
                        is_discounted: body === null || body === void 0 ? void 0 : body.is_discounted,
                        publishedAt: new Date(),
                        emirate: body === null || body === void 0 ? void 0 : body.emirate,
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Paid",
                        userType: "regular",
                        creator: body === null || body === void 0 ? void 0 : body.userId,
                        modifiedBy: body === null || body === void 0 ? void 0 : body.userId,
                    },
                    transacting: trx,
                });
                let ticketMasters = [];
                const ticketCount = body.ticketCount || 1;
                for (let i = 0; i < ticketCount; i++) {
                    let tiket_number = await generateTicketNum("B");
                    const tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id: body === null || body === void 0 ? void 0 : body.ticketId, is_deleted: false },
                    });
                    const secret = process.env.EVENTO_JWT_SECRET;
                    const jwtPayload = {
                        ticketNumber: tiket_number,
                        orderNumber: decode.identifier,
                        ticketType: tiketTypeData === null || tiketTypeData === void 0 ? void 0 : tiketTypeData.id_short,
                    };
                    const token = jwt.sign(jwtPayload, secret);
                    const badgeCategory = (body === null || body === void 0 ? void 0 : body.ticketType) === "executive"
                        ? "Official"
                        : (body === null || body === void 0 ? void 0 : body.ticketType) === "delegate"
                            ? "Full Week"
                            : (body === null || body === void 0 ? void 0 : body.ticketType) === "general_admission"
                                ? "Visitor"
                                : (_a = body === null || body === void 0 ? void 0 : body.day) === null || _a === void 0 ? void 0 : _a.event;
                    let ticket = {
                        ticket_id: body.ticketId,
                        type: body.type,
                        firstName: body.firstName,
                        lastName: body.lastName,
                        email: body.email,
                        day: body === null || body === void 0 ? void 0 : body.day,
                        orderId: order === null || order === void 0 ? void 0 : order.id,
                        ticketNumber: tiket_number,
                        company: body.company,
                        sector: body.sector,
                        designation: body.designation,
                        nationality: body.nationality,
                        residanceCountry: body.residanceCountry,
                        countryCode: body.countryCode,
                        mobile: body.mobile,
                        photo: body.photo,
                        orderNumber: decode.identifier,
                        publishedAt: new Date(),
                        emirate: body === null || body === void 0 ? void 0 : body.emirate,
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        token: token,
                        badgeCategory: badgeCategory,
                        paymentStatus: "Paid",
                        creator: body === null || body === void 0 ? void 0 : body.userId,
                        modifiedBy: body === null || body === void 0 ? void 0 : body.userId,
                        dayShort: (_b = body === null || body === void 0 ? void 0 : body.day) === null || _b === void 0 ? void 0 : _b.id_short,
                    };
                    if (body.type === "myself") {
                        ticket["status"] = "issued";
                    }
                    else {
                        ticket["status"] = "unassigned";
                    }
                    const ticketMaster = await strapi.entityService.create("api::ticket-master.ticket-master", {
                        data: ticket,
                        populate: {
                            ticket_id: true,
                        },
                        transacting: trx,
                    });
                    let externalApiResponse = {};
                    if (body.type === "myself") {
                        externalApiResponse = await axios.post(process.env.EVENTO_VISITOR_INSERT, {
                            OrderNumber: (body === null || body === void 0 ? void 0 : body.orderId) || "",
                            VisitorNumber: (ticketMaster === null || ticketMaster === void 0 ? void 0 : ticketMaster.ticketNumber) || "",
                            FirstName: (body === null || body === void 0 ? void 0 : body.firstName) || "",
                            LastName: (body === null || body === void 0 ? void 0 : body.lastName) || "",
                            Company: (body === null || body === void 0 ? void 0 : body.company) || "",
                            JobTitle: (body === null || body === void 0 ? void 0 : body.designation) || "",
                            Email: (body === null || body === void 0 ? void 0 : body.email) || "",
                            Nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                            BadgeCategory: badgeCategory || "Official",
                            Country: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "",
                            Mobile: `${(_c = body === null || body === void 0 ? void 0 : body.countryCode) === null || _c === void 0 ? void 0 : _c.replace("+", "")} ${body === null || body === void 0 ? void 0 : body.mobile}` ||
                                "",
                            SingleDay: ((_d = body === null || body === void 0 ? void 0 : body.day) === null || _d === void 0 ? void 0 : _d.value) || "Other",
                            TicketType: (body === null || body === void 0 ? void 0 : body.ticketType) || "",
                            Sector: (body === null || body === void 0 ? void 0 : body.sector) || "Other",
                            City: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                            Payment: Number(body === null || body === void 0 ? void 0 : body.totalAmount) > 0 ? "Paid" : "Foc",
                            Emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "",
                            Photo: (body === null || body === void 0 ? void 0 : body.photo) || "",
                            Quantiy: 1,
                        }, {
                            headers: {
                                Authorization: process.env.EVENTO_VISITOR_TOKEN,
                                "Content-Type": "application/json",
                            },
                        });
                    }
                    ticketMasters.push({
                        badgeCategory,
                        ...ticketMaster,
                        payment: Number(body === null || body === void 0 ? void 0 : body.totalAmount) > 0 ? "Paid" : "Foc",
                        externalApiResponse: (externalApiResponse === null || externalApiResponse === void 0 ? void 0 : externalApiResponse.data) || {
                            status: false,
                        },
                    });
                }
                if (body.type === "myself") {
                    let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                    let obj = {
                        key: process.env.MANDRILL_KEY,
                        template_name: process.env.BUY_FOR_MYSELF_TEMPLATE_NAME,
                        template_content: [],
                        message: {
                            to: [
                                {
                                    email: body === null || body === void 0 ? void 0 : body.email,
                                    name: body === null || body === void 0 ? void 0 : body.firstName,
                                    type: "to",
                                },
                            ],
                            from_email: "donotreply@adfw.com",
                            from_name: "Abu Dhabi Finance Week",
                            global_merge_vars: [
                                {
                                    name: "FIRSTNAME",
                                    content: body === null || body === void 0 ? void 0 : body.firstName,
                                },
                                {
                                    name: "FULLNAME",
                                    content: `${body === null || body === void 0 ? void 0 : body.firstName} ${body === null || body === void 0 ? void 0 : body.lastName}`,
                                },
                                {
                                    name: "EMAIL",
                                    content: body === null || body === void 0 ? void 0 : body.email,
                                },
                                {
                                    name: "TICKETTYPE",
                                    content: ((_g = (_f = (_e = ticketMasters[0]) === null || _e === void 0 ? void 0 : _e.day) === null || _f === void 0 ? void 0 : _f.event) === null || _g === void 0 ? void 0 : _g.toLowerCase()) !== "other"
                                        ? `${(_j = (_h = ticketMasters[0]) === null || _h === void 0 ? void 0 : _h.ticket_id) === null || _j === void 0 ? void 0 : _j.title}: ${(_l = (_k = ticketMasters[0]) === null || _k === void 0 ? void 0 : _k.day) === null || _l === void 0 ? void 0 : _l.event}`
                                        : (_o = (_m = ticketMasters[0]) === null || _m === void 0 ? void 0 : _m.ticket_id) === null || _o === void 0 ? void 0 : _o.title,
                                },
                                {
                                    name: "TICKETID",
                                    content: (_p = ticketMasters[0]) === null || _p === void 0 ? void 0 : _p.ticketNumber,
                                },
                                {
                                    name: "ORDERID",
                                    content: body === null || body === void 0 ? void 0 : body.orderId,
                                },
                                {
                                    name: "DOWNLOADTICKET",
                                    content: `${process.env.WEB_URL}ticket-download?ticketNumber=${(_q = ticketMasters[0]) === null || _q === void 0 ? void 0 : _q.ticketNumber}`,
                                },
                                {
                                    name: "APPLEWALLET",
                                    content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${(_r = ticketMasters[0]) === null || _r === void 0 ? void 0 : _r.ticketNumber}`,
                                },
                                {
                                    name: "GOOGLEWALLET",
                                    content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${(_s = ticketMasters[0]) === null || _s === void 0 ? void 0 : _s.ticketNumber}`,
                                },
                                {
                                    name: "HIDEREFUNDS",
                                    content: Number(order === null || order === void 0 ? void 0 : order.paidAmount) == 0 ? true : null,
                                },
                            ],
                        },
                    };
                    await axios.post(mandrilURL, obj);
                }
                else {
                    let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                    let obj = {
                        key: process.env.MANDRILL_KEY,
                        template_name: process.env.BUY_FOR_OTHERS_TEMPLATE_NAME,
                        template_content: [],
                        message: {
                            to: [
                                {
                                    email: body === null || body === void 0 ? void 0 : body.email,
                                    name: body === null || body === void 0 ? void 0 : body.firstName,
                                    type: "to",
                                },
                            ],
                            from_email: "donotreply@adfw.com",
                            from_name: "Abu Dhabi Finance Week",
                            // subject: `New order #${order?.orderId} has been Placed Successfully`,
                            global_merge_vars: [
                                {
                                    name: "FIRSTNAME",
                                    content: body === null || body === void 0 ? void 0 : body.firstName,
                                },
                                {
                                    name: "TICKETCOUNT",
                                    content: order === null || order === void 0 ? void 0 : order.ticketCount,
                                },
                                {
                                    name: "TICKETTYPE",
                                    content: ((_v = (_u = (_t = ticketMasters[0]) === null || _t === void 0 ? void 0 : _t.day) === null || _u === void 0 ? void 0 : _u.event) === null || _v === void 0 ? void 0 : _v.toLowerCase()) !== "other"
                                        ? `${(_x = (_w = ticketMasters[0]) === null || _w === void 0 ? void 0 : _w.ticket_id) === null || _x === void 0 ? void 0 : _x.title}: ${(_z = (_y = ticketMasters[0]) === null || _y === void 0 ? void 0 : _y.day) === null || _z === void 0 ? void 0 : _z.event}`
                                        : (_1 = (_0 = ticketMasters[0]) === null || _0 === void 0 ? void 0 : _0.ticket_id) === null || _1 === void 0 ? void 0 : _1.title,
                                    // body?.day?.event !== "Other" ? `${body?.ticketType}: ${body?.day?.event}` : body?.ticketType,
                                },
                                {
                                    name: "FULLNAME",
                                    content: `${body === null || body === void 0 ? void 0 : body.firstName} ${body === null || body === void 0 ? void 0 : body.lastName}`,
                                },
                                {
                                    name: "EMAIL",
                                    content: order === null || order === void 0 ? void 0 : order.email,
                                },
                                {
                                    name: "MANAGETICKET",
                                    content: `${process.env.WEB_URL}ticketing?jwt=${body === null || body === void 0 ? void 0 : body.token}`,
                                },
                                {
                                    name: "ORDERID",
                                    content: body === null || body === void 0 ? void 0 : body.orderId,
                                },
                                {
                                    name: "HIDEREFUNDS",
                                    content: Number(order === null || order === void 0 ? void 0 : order.paidAmount) == 0 ? true : null,
                                },
                            ],
                        },
                    };
                    await axios.post(mandrilURL, obj);
                }
                await strapi
                    .service("api::discount-code.discount-code")
                    .updateDiscountCodeCount(body === null || body === void 0 ? void 0 : body.discountId);
                // update log
                await strapi.db.query("api::payment-log.payment-log").update({
                    where: {
                        orderId: body.orderId,
                    },
                    data: {
                        status: "succeeded",
                        details: { order, ticketMasters },
                    },
                });
                let res = {
                    order,
                    ticketMasters,
                };
                return new dataResponse_dto_1.DataResponseDto(res, "Order Created successfully");
            });
            return result;
        }
        catch (err) {
            console.log(err);
            if ((_a = err.details) === null || _a === void 0 ? void 0 : _a.errors) {
                return new dataResponse_dto_1.DataResponseDto(null, false, err.details.errors);
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
            }
        }
    },
    createRedeemTicket: async (body) => {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
                const redeemData = await strapi.db
                    .query("api::redeem-link.redeem-link")
                    .findOne({
                    where: { id: body === null || body === void 0 ? void 0 : body.redeemDataId, is_deleted: false },
                });
                if ((redeemData === null || redeemData === void 0 ? void 0 : redeemData.total_remaining_count) <= 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "No tickets left");
                }
                if ((body === null || body === void 0 ? void 0 : body.id_short) === "single_day_delegate") {
                    if (((_a = body === null || body === void 0 ? void 0 : body.day) === null || _a === void 0 ? void 0 : _a.id_short) === "resolve" &&
                        redeemData.resolve_remaining_count <= 0) {
                        return new dataResponse_dto_1.DataResponseDto(null, "No tickets left");
                    }
                    else if (((_b = body === null || body === void 0 ? void 0 : body.day) === null || _b === void 0 ? void 0 : _b.id_short) === "asset_abu_dhabi" &&
                        (redeemData === null || redeemData === void 0 ? void 0 : redeemData.asset_remaining_count) <= 0) {
                        return new dataResponse_dto_1.DataResponseDto(null, "No tickets left");
                    }
                    else if (((_c = body === null || body === void 0 ? void 0 : body.day) === null || _c === void 0 ? void 0 : _c.id_short) === "fintech_abu_dhabi" &&
                        (redeemData === null || redeemData === void 0 ? void 0 : redeemData.fintech_remaining_count) <= 0) {
                        return new dataResponse_dto_1.DataResponseDto(null, "No tickets left");
                    }
                    else if (((_d = body === null || body === void 0 ? void 0 : body.day) === null || _d === void 0 ? void 0 : _d.id_short) === "adsff" &&
                        (redeemData === null || redeemData === void 0 ? void 0 : redeemData.adsff_remaining_count) <= 0) {
                        return new dataResponse_dto_1.DataResponseDto(null, "No tickets left");
                    }
                    // if (Number(redeemData[`${body?.redeemKey}`]) <= 0) {
                    //   return new DataResponseDto(null, "No tickets left");
                    // }
                }
                const badgeCategory = (body === null || body === void 0 ? void 0 : body.id_short) === "executive"
                    ? "Official"
                    : (body === null || body === void 0 ? void 0 : body.id_short) === "delegate"
                        ? "Full Week"
                        : (body === null || body === void 0 ? void 0 : body.id_short) === "general_admission"
                            ? "Visitor"
                            : (_e = body === null || body === void 0 ? void 0 : body.day) === null || _e === void 0 ? void 0 : _e.event;
                let ticketNumber = await generateTicketNum("R");
                let ticket = {
                    ticket_id: body === null || body === void 0 ? void 0 : body.ticketId,
                    type: body === null || body === void 0 ? void 0 : body.type,
                    firstName: body === null || body === void 0 ? void 0 : body.firstName,
                    lastName: body === null || body === void 0 ? void 0 : body.lastName,
                    email: body === null || body === void 0 ? void 0 : body.email,
                    day: body === null || body === void 0 ? void 0 : body.day,
                    orderId: body === null || body === void 0 ? void 0 : body.orderId,
                    ticketNumber: ticketNumber,
                    company: body === null || body === void 0 ? void 0 : body.company,
                    sector: body === null || body === void 0 ? void 0 : body.sector,
                    designation: body === null || body === void 0 ? void 0 : body.designation,
                    nationality: body === null || body === void 0 ? void 0 : body.nationality,
                    residanceCountry: body === null || body === void 0 ? void 0 : body.residanceCountry,
                    countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                    mobile: body === null || body === void 0 ? void 0 : body.mobile,
                    photo: body === null || body === void 0 ? void 0 : body.photo,
                    orderNumber: body === null || body === void 0 ? void 0 : body.orderNumber,
                    publishedAt: new Date(),
                    emirate: body === null || body === void 0 ? void 0 : body.emirate,
                    utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                    utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                    utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                    utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                    utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                    token: "",
                    status: "issued",
                    ticketHolder: "redeem_link",
                    badgeCategory: badgeCategory,
                    dayShort: (_f = body === null || body === void 0 ? void 0 : body.day) === null || _f === void 0 ? void 0 : _f.id_short,
                };
                const ticketMaster = await strapi.entityService.create("api::ticket-master.ticket-master", {
                    data: ticket,
                    populate: {
                        ticket_id: true,
                    },
                    transacting: trx,
                });
                let newRemainingCount = Number(redeemData.total_remaining_count) - 1;
                let redeemObj = {
                    total_remaining_count: Number(newRemainingCount),
                    redeemedTicketCount: Number(redeemData.redeemedTicketCount) + 1,
                };
                if ((body === null || body === void 0 ? void 0 : body.id_short) === "single_day_delegate") {
                    if (((_g = body === null || body === void 0 ? void 0 : body.day) === null || _g === void 0 ? void 0 : _g.id_short) === "resolve") {
                        redeemObj.resolve_remaining_count =
                            Number(redeemData.resolve_remaining_count) - 1;
                    }
                    else if (((_h = body === null || body === void 0 ? void 0 : body.day) === null || _h === void 0 ? void 0 : _h.id_short) === "asset_abu_dhabi") {
                        redeemObj.asset_remaining_count =
                            Number(redeemData.asset_remaining_count) - 1;
                    }
                    else if (((_j = body === null || body === void 0 ? void 0 : body.day) === null || _j === void 0 ? void 0 : _j.id_short) === "fintech_abu_dhabi") {
                        redeemObj.fintech_remaining_count =
                            Number(redeemData.fintech_remaining_count) - 1;
                    }
                    else if (((_k = body === null || body === void 0 ? void 0 : body.day) === null || _k === void 0 ? void 0 : _k.id_short) === "adsff") {
                        redeemObj.adsff_remaining_count =
                            Number(redeemData.adsff_remaining_count) - 1;
                    }
                }
                if (Number(newRemainingCount) <= 0) {
                    redeemObj.status = false;
                }
                await strapi.db.query("api::redeem-link.redeem-link").update({
                    where: {
                        id: body.redeemDataId,
                    },
                    data: redeemObj,
                });
                let URL = process.env.EVENTO_VISITOR_INSERT;
                let reqObj = {
                    OrderNumber: (body === null || body === void 0 ? void 0 : body.orderNumber) || "",
                    VisitorNumber: ticketNumber || "",
                    FirstName: (body === null || body === void 0 ? void 0 : body.firstName) || "",
                    LastName: (body === null || body === void 0 ? void 0 : body.lastName) || "",
                    Company: (body === null || body === void 0 ? void 0 : body.company) || "",
                    JobTitle: (body === null || body === void 0 ? void 0 : body.designation) || "",
                    Email: (body === null || body === void 0 ? void 0 : body.email) || "",
                    Nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                    BadgeCategory: badgeCategory || "Official",
                    Country: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "",
                    Mobile: `${(_l = body === null || body === void 0 ? void 0 : body.countryCode) === null || _l === void 0 ? void 0 : _l.replace("+", "")} ${body === null || body === void 0 ? void 0 : body.mobile} ` || "",
                    SingleDay: ((_m = body === null || body === void 0 ? void 0 : body.day) === null || _m === void 0 ? void 0 : _m.event) || "Other",
                    TicketType: (body === null || body === void 0 ? void 0 : body.ticketType) || "",
                    Sector: (body === null || body === void 0 ? void 0 : body.sector) || "Other",
                    City: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                    Payment: "Foc",
                    Emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "",
                    Photo: (body === null || body === void 0 ? void 0 : body.photo) || "",
                    Quantiy: 1,
                };
                await axios.post(URL, reqObj, {
                    headers: {
                        Authorization: process.env.EVENTO_VISITOR_TOKEN,
                        "Content-Type": "application/json",
                    },
                });
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                let obj = {
                    key: process.env.MANDRILL_KEY,
                    template_name: process.env.ISSUE_TICKET_TEMPLATE_NAME,
                    template_content: [],
                    message: {
                        to: [
                            {
                                email: body === null || body === void 0 ? void 0 : body.email,
                                name: body === null || body === void 0 ? void 0 : body.firstName,
                                type: "to",
                            },
                        ],
                        from_email: "donotreply@adfw.com",
                        from_name: "Abu Dhabi Finance Week",
                        global_merge_vars: [
                            {
                                name: "FIRSTNAME",
                                content: body === null || body === void 0 ? void 0 : body.firstName,
                            },
                            {
                                name: "FULLNAME",
                                content: `${body === null || body === void 0 ? void 0 : body.firstName} ${body === null || body === void 0 ? void 0 : body.lastName}`,
                            },
                            {
                                name: "EMAIL",
                                content: body === null || body === void 0 ? void 0 : body.email,
                            },
                            {
                                name: "TICKETTYPE",
                                content: ((_p = (_o = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _o === void 0 ? void 0 : _o.event) === null || _p === void 0 ? void 0 : _p.toLowerCase()) === "other"
                                    ? ticketMaster.ticket_id.title
                                    : `${(_q = ticketMaster === null || ticketMaster === void 0 ? void 0 : ticketMaster.ticket_id) === null || _q === void 0 ? void 0 : _q.title}: ${(_r = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _r === void 0 ? void 0 : _r.event}`,
                                // body?.ticketType,
                            },
                            {
                                name: "TICKETID",
                                content: ticketNumber,
                            },
                            {
                                name: "ORDERID",
                                content: body === null || body === void 0 ? void 0 : body.OrderNumber,
                            },
                            {
                                name: "DOWNLOADTICKET",
                                content: `${process.env.WEB_URL}ticket-download?ticketNumber=${ticketNumber}`,
                            },
                            {
                                name: "APPLEWALLET",
                                content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${ticketNumber}`,
                            },
                            {
                                name: "GOOGLEWALLET",
                                content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${ticketNumber}`,
                            },
                        ],
                    },
                };
                await axios.post(mandrilURL, obj);
                return new dataResponse_dto_1.DataResponseDto(ticketMaster, "Redeem ticket created successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    uploadSponsorTicket: async (body) => {
        try {
            const knex = strapi.db.connection;
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4;
                const orderData = await strapi.db.query("api::order.order").findOne({
                    where: { orderId: body.orderId, is_deleted: false },
                });
                if (!orderData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Order not found");
                }
                const sponsorData = await strapi.db
                    .query("api::sponsor.sponsor")
                    .findOne({
                    where: { sponsor_id: body.sponsorId, is_deleted: false },
                    populate: {
                        ticket_masters: true,
                    },
                });
                if (!sponsorData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Sponsor not found");
                }
                if (!body.ticketData || body.ticketData.length === 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please add tickets data");
                }
                const addTicket = [];
                const deleteIds = [];
                const updateTicket = [];
                let remaining_executive_count = Number(sponsorData.remaining_executive_count) || 0;
                let remaining_delegate_count = Number(sponsorData.remaining_delegate_count) || 0;
                let remaining_padock_club_count = Number(sponsorData.remaining_padock_club_count) || 0;
                let remaining_general_admission_count = Number(sponsorData.remaining_general_admission_count) || 0;
                let remaining_single_day_delegate_count = Number(sponsorData.remaining_single_day_delegate_count) || 0;
                let remaining_resolve_count = Number(sponsorData.remaining_resolve_count) | 0;
                let remaining_asset_abu_dhabi_count = Number(sponsorData.remaining_asset_abu_dhabi_count) || 0;
                let remaining_fintech_abu_dhabi_count = Number(sponsorData.remaining_fintech_abu_dhabi_count) || 0;
                let remaining_adsff_count = Number(sponsorData.remaining_adsff_count) || 0;
                function updateRemainingCount(ticketIdShort, dayIdShort, countChange) {
                    switch (ticketIdShort) {
                        case "general_admission":
                            remaining_general_admission_count += Number(countChange);
                            break;
                        case "executive":
                            remaining_executive_count += Number(countChange);
                            break;
                        case "delegate":
                            remaining_delegate_count += Number(countChange);
                            break;
                        case "padock_club":
                            remaining_padock_club_count += Number(countChange);
                            break;
                        case "single_day_delegate":
                            remaining_single_day_delegate_count += Number(countChange);
                            switch (dayIdShort) {
                                case "resolve":
                                    remaining_resolve_count += Number(countChange);
                                    break;
                                case "asset_abu_dhabi":
                                    remaining_asset_abu_dhabi_count += Number(countChange);
                                    break;
                                case "fintech_abu_dhabi":
                                    remaining_fintech_abu_dhabi_count += Number(countChange);
                                    break;
                                case "adsff":
                                    remaining_adsff_count += Number(countChange);
                                    break;
                            }
                            break;
                    }
                }
                const createdTicketIds = [];
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.filter(item => item.status == "draft").length);
                for (const [index, ticket] of body.ticketData.filter((item) => item.status == "draft").entries()) {
                    let obj = {
                        type: body === null || body === void 0 ? void 0 : body.type,
                        first_name: ticket === null || ticket === void 0 ? void 0 : ticket.firstName,
                        last_name: ticket === null || ticket === void 0 ? void 0 : ticket.lastName,
                        email: (_a = ticket === null || ticket === void 0 ? void 0 : ticket.email) === null || _a === void 0 ? void 0 : _a.trim(),
                        day: ticket === null || ticket === void 0 ? void 0 : ticket.day,
                        order_number: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                        ticket_holder: "sponsor",
                        day_short: (_b = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _b === void 0 ? void 0 : _b.id_short,
                    };
                    if (ticket.action === "add") {
                        let badgeCategory = ((_c = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.id_short) === "executive"
                            ? "Official"
                            : ((_d = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short) === "delegate"
                                ? "Full Week"
                                : ((_e = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _e === void 0 ? void 0 : _e.id_short) === "general_admission"
                                    ? "Visitor"
                                    : (_f = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _f === void 0 ? void 0 : _f.event;
                        obj.status = body.isSave ? "draft" : "unassigned";
                        obj.badge_category = (ticket === null || ticket === void 0 ? void 0 : ticket.badgeCategory) || badgeCategory;
                        obj.published_at = new Date();
                        obj.created_at = new Date();
                        obj.is_deleted = false;
                        obj.payment_status = "Free";
                        obj.allow_email = true;
                        obj.allow_chat = false;
                        obj.ticket_number = ticketNumbers[index];
                        addTicket.push(obj);
                        createdTicketIds.push((_g = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _g === void 0 ? void 0 : _g.id);
                        if (!body.isSave) {
                            updateRemainingCount((_h = ticket.ticket_id) === null || _h === void 0 ? void 0 : _h.id_short, (_j = ticket.day) === null || _j === void 0 ? void 0 : _j.id_short, -1);
                        }
                    }
                    else if (ticket.action === "delete") {
                        deleteIds.push(ticket.id);
                        if (ticket.status === "unassigned") {
                            updateRemainingCount((_k = ticket.ticket_id) === null || _k === void 0 ? void 0 : _k.id_short, (_l = ticket.day) === null || _l === void 0 ? void 0 : _l.id_short, +1);
                        }
                    }
                    else {
                        obj.status =
                            ticket.status == "draft"
                                ? !(body === null || body === void 0 ? void 0 : body.isSave)
                                    ? "unassigned"
                                    : ticket.status
                                : ticket.status;
                        obj.id = ticket.id;
                        obj.ticket_number = body === null || body === void 0 ? void 0 : body.ticketNumber;
                        updateTicket.push(obj);
                        const data = await strapi.db
                            .query("api::ticket-master.ticket-master")
                            .findOne({
                            where: { id: ticket.id },
                            populate: { ticket_id: true },
                        });
                        if (((_m = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _m === void 0 ? void 0 : _m.id_short) !== ((_o = ticket.ticket_id) === null || _o === void 0 ? void 0 : _o.id_short)) {
                            if ((data === null || data === void 0 ? void 0 : data.status) == "unassigned" &&
                                obj.status == "unassigned") {
                                // reduce new ticket count
                                updateRemainingCount((_p = ticket.ticket_id) === null || _p === void 0 ? void 0 : _p.id_short, (_q = ticket.day) === null || _q === void 0 ? void 0 : _q.id_short, -1);
                                // increase existing ticket count
                                updateRemainingCount((_r = data.ticket_id) === null || _r === void 0 ? void 0 : _r.id_short, (_s = data.day) === null || _s === void 0 ? void 0 : _s.id_short, 1);
                            }
                        }
                        if ((data === null || data === void 0 ? void 0 : data.status) == "draft" && obj.status == "unassigned") {
                            if (((_t = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _t === void 0 ? void 0 : _t.id_short) == "single_day_delegate" &&
                                ((_u = obj.ticket_id) === null || _u === void 0 ? void 0 : _u.id_short) == "single_day_delegate") {
                                if (((_v = data === null || data === void 0 ? void 0 : data.day) === null || _v === void 0 ? void 0 : _v.id_short) == ((_w = obj.day) === null || _w === void 0 ? void 0 : _w.id_short)) {
                                    updateRemainingCount((_x = ticket.ticket_id) === null || _x === void 0 ? void 0 : _x.id_short, (_y = ticket.day) === null || _y === void 0 ? void 0 : _y.id_short, -1);
                                }
                                else {
                                    // decrease new ticket count
                                    updateRemainingCount((_z = ticket.ticket_id) === null || _z === void 0 ? void 0 : _z.id_short, (_0 = ticket.day) === null || _0 === void 0 ? void 0 : _0.id_short, -1);
                                    // increase existing ticket count
                                    updateRemainingCount((_1 = data.ticket_id) === null || _1 === void 0 ? void 0 : _1.id_short, (_2 = data.day) === null || _2 === void 0 ? void 0 : _2.id_short, 1);
                                }
                            }
                            else {
                                updateRemainingCount((_3 = ticket.ticket_id) === null || _3 === void 0 ? void 0 : _3.id_short, (_4 = ticket.day) === null || _4 === void 0 ? void 0 : _4.id_short, -1);
                            }
                        }
                    }
                }
                if (remaining_general_admission_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for general admission tickets.");
                }
                else if (remaining_executive_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for executive tickets.");
                }
                else if (remaining_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for delegate tickets.");
                }
                else if (remaining_padock_club_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for padock club tickets");
                }
                else if (remaining_single_day_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for single day limit");
                }
                else if (remaining_resolve_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for resolve tickets.");
                }
                else if (remaining_asset_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for asset abu dhabi tickets.");
                }
                else if (remaining_fintech_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for fintech abu dhabi tickets.");
                }
                else if (remaining_adsff_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for adsff tickets.");
                }
                let limitObj = {
                    remaining_executive_count: remaining_executive_count,
                    remaining_delegate_count: remaining_delegate_count,
                    remaining_padock_club_count: remaining_padock_club_count,
                    remaining_general_admission_count: remaining_general_admission_count,
                    remaining_single_day_delegate_count: remaining_single_day_delegate_count,
                    remaining_resolve_count: remaining_resolve_count,
                    remaining_asset_abu_dhabi_count: remaining_asset_abu_dhabi_count,
                    remaining_fintech_abu_dhabi_count: remaining_fintech_abu_dhabi_count,
                    remaining_adsff_count: remaining_adsff_count,
                };
                // update remaining count
                await strapi.entityService.update("api::sponsor.sponsor", sponsorData.id, {
                    data: limitObj,
                    transacting: trx,
                });
                const responseArray = [];
                if (addTicket.length) {
                    const createdData = await knex("ticket_masters").insert(addTicket).transacting(trx).returning("id");
                    // find the laster order from ticket_masters_sponsor_links table
                    const ticket_masters_sponsor_link_order = await strapi.db.connection('ticket_masters_sponsor_links')
                        .where({ sponsor_id: sponsorData === null || sponsorData === void 0 ? void 0 : sponsorData.id })
                        .orderBy('id', 'desc')
                        .first();
                    let last_ticket_master_order = 0;
                    if (ticket_masters_sponsor_link_order) {
                        last_ticket_master_order = Number(ticket_masters_sponsor_link_order.ticket_master_order);
                    }
                    const ticket_ticket_master_data = [];
                    const sponsor_ticket_link_data = [];
                    const order_ticket_data = createdData.map((item, index) => {
                        ticket_ticket_master_data.push({
                            ticket_master_id: item.id,
                            ticket_id: createdTicketIds[index],
                            ticket_master_order: Number(index) + 1
                        });
                        sponsor_ticket_link_data.push({
                            ticket_master_id: item.id,
                            sponsor_id: sponsorData.id,
                            ticket_master_order: Number(last_ticket_master_order) + index + 1
                        });
                        return {
                            ticket_master_id: item.id,
                            order_id: orderData.id,
                            ticket_master_order: Number(index) + 1
                        };
                    });
                    // 4. create entries to ticket_masters_order_id_links table
                    await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                    // 5. create entries to ticket_masters_ticket_id_links table
                    await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                    // 6. create entries to ticket_masters_sponsor_links table
                    await knex("ticket_masters_sponsor_links").insert(sponsor_ticket_link_data).transacting(trx);
                    responseArray.push({
                        createdEntriesCount: createdData,
                        addReqCount: addTicket === null || addTicket === void 0 ? void 0 : addTicket.length
                    });
                }
                if (deleteIds.length) {
                    const deletedData = await knex("ticket_masters").whereIn("id", deleteIds).del().transacting(trx);
                    responseArray.push({
                        deletedEntriesCount: deletedData,
                        deletedReqCount: deleteIds.length,
                    });
                }
                ;
                if (updateTicket.length) {
                    const updatedArray = [];
                    let updateSuccessCount = 0;
                    let updateFailedCount = 0;
                    await Promise.all(updateTicket.map(async (item) => {
                        if (item === null || item === void 0 ? void 0 : item.id) {
                            await knex("ticket_masters")
                                .where("id", item.id)
                                .update(item)
                                .transacting(trx)
                                .returning('id');
                            updateSuccessCount++;
                            updatedArray.push({
                                updateStatus: true,
                                message: "success",
                                id: item === null || item === void 0 ? void 0 : item.id,
                            });
                        }
                        else {
                            updateFailedCount++;
                            updatedArray.push({
                                updateStatus: false,
                                message: "provide id for updating data",
                                data: item,
                            });
                        }
                    }));
                    responseArray.push({
                        updatedEntries: updateSuccessCount,
                        failedEntries: updateFailedCount,
                        updateReqCount: updateTicket.length,
                        data: updatedArray,
                    });
                }
                return new dataResponse_dto_1.DataResponseDto(responseArray, "Sponsor tickets uploaded successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    uploadAdgmTicket: async (body) => {
        try {
            const knex = strapi.db.connection;
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4;
                const orderData = await strapi.db.query("api::order.order").findOne({
                    where: { orderId: body.orderId, is_deleted: false },
                });
                if (!orderData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Order not found");
                }
                const adgmData = await strapi.db.query("api::adgm.adgm").findOne({
                    where: { adgm_id: body.adgmId, is_deleted: false },
                    populate: {
                        ticket_masters: true,
                    },
                });
                if (!adgmData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Adgms not found");
                }
                if (!body.ticketData || body.ticketData.length === 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please add tickets data");
                }
                const addTicket = [];
                const deleteIds = [];
                const updateTicket = [];
                let remaining_executive_count = Number(adgmData.remaining_executive);
                let remaining_delegate_count = Number(adgmData.remaining_delegate);
                let remaining_padock_club_count = Number(adgmData.remaining_paddock);
                let remaining_general_admission_count = Number(adgmData.remainig_general_admission);
                let remaining_single_day_delegate_count = Number(adgmData.remaining_single_day);
                let remaining_resolve_count = Number(adgmData.remaining_resolve);
                let remaining_asset_abu_dhabi_count = Number(adgmData.remaining_asset_abu_dhabi);
                let remaining_fintech_abu_dhabi_count = Number(adgmData.remaining_fintech_abu_dhabi);
                let remaining_adsff_count = Number(adgmData.remaining_adsff);
                function updateRemainingCount(ticketIdShort, dayIdShort, countChange) {
                    switch (ticketIdShort) {
                        case "general_admission":
                            remaining_general_admission_count += Number(countChange);
                            break;
                        case "executive":
                            remaining_executive_count += Number(countChange);
                            break;
                        case "delegate":
                            remaining_delegate_count += Number(countChange);
                            break;
                        case "padock_club":
                            remaining_padock_club_count += Number(countChange);
                            break;
                        case "single_day_delegate":
                            remaining_single_day_delegate_count += Number(countChange);
                            switch (dayIdShort) {
                                case "resolve":
                                    remaining_resolve_count += Number(countChange);
                                    break;
                                case "asset_abu_dhabi":
                                    remaining_asset_abu_dhabi_count += Number(countChange);
                                    break;
                                case "fintech_abu_dhabi":
                                    remaining_fintech_abu_dhabi_count += Number(countChange);
                                    break;
                                case "adsff":
                                    remaining_adsff_count += Number(countChange);
                                    break;
                            }
                            break;
                    }
                }
                ;
                const createdTicketIds = [];
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.filter(item => item.status == "draft").length);
                for (const [index, ticket] of body.ticketData.filter((item) => item.status == "draft").entries()) {
                    let obj = {
                        type: body === null || body === void 0 ? void 0 : body.type,
                        first_name: ticket === null || ticket === void 0 ? void 0 : ticket.firstName,
                        last_name: ticket === null || ticket === void 0 ? void 0 : ticket.lastName,
                        email: (_a = ticket === null || ticket === void 0 ? void 0 : ticket.email) === null || _a === void 0 ? void 0 : _a.trim(),
                        day: ticket === null || ticket === void 0 ? void 0 : ticket.day,
                        order_number: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                        ticket_holder: "adgm",
                        day_short: (_b = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _b === void 0 ? void 0 : _b.id_short,
                    };
                    if (ticket.action === "add") {
                        let badgeCategory = ((_c = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.id_short) === "executive"
                            ? "Official"
                            : ((_d = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short) === "delegate"
                                ? "Full Week"
                                : ((_e = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _e === void 0 ? void 0 : _e.id_short) === "general_admission"
                                    ? "Visitor"
                                    : (_f = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _f === void 0 ? void 0 : _f.event;
                        obj.status = body.isSave ? "draft" : "unassigned";
                        obj.badge_category = (ticket === null || ticket === void 0 ? void 0 : ticket.badgeCategory) || badgeCategory;
                        obj.published_at = new Date();
                        obj.is_deleted = false;
                        obj.created_at = new Date();
                        obj.payment_status = "Free";
                        obj.allow_email = true;
                        obj.allow_chat = false;
                        obj.ticket_number = ticketNumbers[index];
                        addTicket.push(obj);
                        createdTicketIds.push((_g = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _g === void 0 ? void 0 : _g.id);
                        if (!body.isSave) {
                            updateRemainingCount((_h = ticket.ticket_id) === null || _h === void 0 ? void 0 : _h.id_short, (_j = ticket.day) === null || _j === void 0 ? void 0 : _j.id_short, -1);
                        }
                    }
                    else if (ticket.action === "delete") {
                        deleteIds.push(ticket.id);
                        if (ticket.status === "unassigned") {
                            updateRemainingCount((_k = ticket.ticket_id) === null || _k === void 0 ? void 0 : _k.id_short, (_l = ticket.day) === null || _l === void 0 ? void 0 : _l.id_short, +1);
                        }
                    }
                    else {
                        obj.status =
                            ticket.status == "draft"
                                ? !(body === null || body === void 0 ? void 0 : body.isSave)
                                    ? "unassigned"
                                    : ticket.status
                                : ticket.status;
                        obj.id = ticket.id;
                        obj.ticket_number = body === null || body === void 0 ? void 0 : body.ticketNumber;
                        updateTicket.push(obj);
                        const data = await strapi.db
                            .query("api::ticket-master.ticket-master")
                            .findOne({
                            where: { id: ticket.id },
                            populate: { ticket_id: true },
                        });
                        if (((_m = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _m === void 0 ? void 0 : _m.id_short) !== ((_o = ticket.ticket_id) === null || _o === void 0 ? void 0 : _o.id_short)) {
                            if ((data === null || data === void 0 ? void 0 : data.status) == "unassigned" &&
                                obj.status == "unassigned") {
                                // reduce new ticket count
                                updateRemainingCount((_p = ticket.ticket_id) === null || _p === void 0 ? void 0 : _p.id_short, (_q = ticket.day) === null || _q === void 0 ? void 0 : _q.id_short, -1);
                                // increase existing ticket count
                                updateRemainingCount((_r = data.ticket_id) === null || _r === void 0 ? void 0 : _r.id_short, (_s = data.day) === null || _s === void 0 ? void 0 : _s.id_short, 1);
                            }
                        }
                        if ((data === null || data === void 0 ? void 0 : data.status) == "draft" && obj.status == "unassigned") {
                            if (((_t = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _t === void 0 ? void 0 : _t.id_short) == "single_day_delegate" &&
                                ((_u = obj.ticket_id) === null || _u === void 0 ? void 0 : _u.id_short) == "single_day_delegate") {
                                if (((_v = data === null || data === void 0 ? void 0 : data.day) === null || _v === void 0 ? void 0 : _v.id_short) == ((_w = obj.day) === null || _w === void 0 ? void 0 : _w.id_short)) {
                                    updateRemainingCount((_x = ticket.ticket_id) === null || _x === void 0 ? void 0 : _x.id_short, (_y = ticket.day) === null || _y === void 0 ? void 0 : _y.id_short, -1);
                                }
                                else {
                                    // reduce new ticket count
                                    updateRemainingCount((_z = ticket.ticket_id) === null || _z === void 0 ? void 0 : _z.id_short, (_0 = ticket.day) === null || _0 === void 0 ? void 0 : _0.id_short, -1);
                                    // increase existing ticket count
                                    updateRemainingCount((_1 = data.ticket_id) === null || _1 === void 0 ? void 0 : _1.id_short, (_2 = data.day) === null || _2 === void 0 ? void 0 : _2.id_short, 1);
                                }
                            }
                            else {
                                updateRemainingCount((_3 = ticket.ticket_id) === null || _3 === void 0 ? void 0 : _3.id_short, (_4 = ticket.day) === null || _4 === void 0 ? void 0 : _4.id_short, -1);
                            }
                        }
                    }
                }
                if (remaining_general_admission_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for general admission tickets.");
                }
                else if (remaining_executive_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for executive tickets.");
                }
                else if (remaining_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for delegate tickets.");
                }
                else if (remaining_padock_club_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for padock club tickets");
                }
                else if (remaining_single_day_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for single day limit");
                }
                else if (remaining_resolve_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for resolve tickets.");
                }
                else if (remaining_asset_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for asset abu dhabi tickets.");
                }
                else if (remaining_fintech_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for fintech abu dhabi tickets.");
                }
                else if (remaining_adsff_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for adsff tickets.");
                }
                let limitObj = {
                    remaining_executive: remaining_executive_count,
                    remaining_delegate: remaining_delegate_count,
                    remaining_paddock: remaining_padock_club_count,
                    remainig_general_admission: remaining_general_admission_count,
                    remaining_single_day: remaining_single_day_delegate_count,
                    remaining_resolve: remaining_resolve_count,
                    remaining_asset_abu_dhabi: remaining_asset_abu_dhabi_count,
                    remaining_fintech_abu_dhabi: remaining_fintech_abu_dhabi_count,
                    remaining_adsff: remaining_adsff_count,
                };
                // update remaining count
                await strapi.entityService.update("api::adgm.adgm", adgmData.id, {
                    data: limitObj,
                    transacting: trx,
                });
                const responseArray = [];
                if (addTicket.length) {
                    const createdData = await knex("ticket_masters").insert(addTicket).transacting(trx).returning("id");
                    // find the laster order from ticket_masters_adgm_links table
                    const ticket_masters_adgm_link_order = await strapi.db.connection('ticket_masters_adgm_links')
                        .where({ adgm_id: adgmData === null || adgmData === void 0 ? void 0 : adgmData.id })
                        .orderBy('id', 'desc')
                        .first();
                    let last_ticket_master_order = 0;
                    if (ticket_masters_adgm_link_order) {
                        last_ticket_master_order = Number(ticket_masters_adgm_link_order.ticket_master_order);
                    }
                    const ticket_ticket_master_data = [];
                    const adgm_ticket_link_data = [];
                    const order_ticket_data = createdData.map((item, index) => {
                        ticket_ticket_master_data.push({
                            ticket_master_id: item.id,
                            ticket_id: createdTicketIds[index],
                            ticket_master_order: Number(index) + 1
                        });
                        adgm_ticket_link_data.push({
                            ticket_master_id: item.id,
                            adgm_id: adgmData.id,
                            ticket_master_order: Number(last_ticket_master_order) + index + 1
                        });
                        return {
                            ticket_master_id: item.id,
                            order_id: orderData.id,
                            ticket_master_order: Number(index) + 1
                        };
                    });
                    // 4. create entries to ticket_masters_order_id_links table
                    await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                    // 5. create entries to ticket_masters_ticket_id_links table
                    await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                    // 6. create entries to ticket_masters_adgm_links table
                    await knex("ticket_masters_adgm_links").insert(adgm_ticket_link_data).transacting(trx);
                    responseArray.push({
                        createdEntriesCount: createdData,
                        addReqCount: addTicket === null || addTicket === void 0 ? void 0 : addTicket.length
                    });
                }
                if (deleteIds.length) {
                    const deletedData = await knex("ticket_masters").whereIn("id", deleteIds).del().transacting(trx);
                    responseArray.push({
                        deletedEntriesCount: deletedData,
                        deletedReqCount: deleteIds.length,
                    });
                }
                ;
                if (updateTicket.length) {
                    const updatedArray = [];
                    let updateSuccessCount = 0;
                    let updateFailedCount = 0;
                    await Promise.all(updateTicket.map(async (item) => {
                        if (item === null || item === void 0 ? void 0 : item.id) {
                            await knex("ticket_masters")
                                .where("id", item.id)
                                .update(item)
                                .transacting(trx)
                                .returning('id');
                            updateSuccessCount++;
                            updatedArray.push({
                                updateStatus: true,
                                message: "success",
                                id: item === null || item === void 0 ? void 0 : item.id,
                            });
                        }
                        else {
                            updateFailedCount++;
                            updatedArray.push({
                                updateStatus: false,
                                message: "provide id for updating data",
                                data: item,
                            });
                        }
                    }));
                    responseArray.push({
                        updatedEntries: updateSuccessCount,
                        failedEntries: updateFailedCount,
                        updateReqCount: updateTicket.length,
                        data: updatedArray,
                    });
                }
                return new dataResponse_dto_1.DataResponseDto(responseArray, "Adgm tickets uploaded successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    uploadUserTickets: async (body) => {
        try {
            const knex = strapi.db.connection;
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b;
                if (((_a = body === null || body === void 0 ? void 0 : body.ticketData) === null || _a === void 0 ? void 0 : _a.length) === 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please provide tickets data");
                }
                if (!(body === null || body === void 0 ? void 0 : body.userId)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please provide user id");
                }
                // generate order id
                let order_number = await generateOrderNum("others");
                // 1. insert order entry
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: order_number,
                        type: "others",
                        eventDate: new Date(),
                        firstName: (body === null || body === void 0 ? void 0 : body.firstName) || "",
                        lastName: (body === null || body === void 0 ? void 0 : body.lastName) || "",
                        email: (body === null || body === void 0 ? void 0 : body.email) || "",
                        company: (body === null || body === void 0 ? void 0 : body.company) || "",
                        sector: (body === null || body === void 0 ? void 0 : body.sector) || "",
                        designation: (body === null || body === void 0 ? void 0 : body.designation) || "",
                        nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                        residanceCountry: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "",
                        countryCode: (body === null || body === void 0 ? void 0 : body.countryCode) || "",
                        mobile: (body === null || body === void 0 ? void 0 : body.mobile) || "",
                        photo: (body === null || body === void 0 ? void 0 : body.photo) || "",
                        ticketCount: ((_b = body === null || body === void 0 ? void 0 : body.ticketData) === null || _b === void 0 ? void 0 : _b.length) || 0,
                        discountAmount: 0,
                        totalAmount: 0,
                        paidAmount: 0,
                        is_discounted: false,
                        publishedAt: new Date(),
                        emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "",
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Free",
                        userType: body === null || body === void 0 ? void 0 : body.ticketHolder,
                        inviteeName: body === null || body === void 0 ? void 0 : body.inviteeName,
                        creator: body === null || body === void 0 ? void 0 : body.userId
                    },
                    transacting: trx,
                });
                // Generate bulk ticket numbers
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.length);
                const ticketIds = [];
                const mandrillEmailData = [];
                const ticketData = body === null || body === void 0 ? void 0 : body.ticketData.map((element, index) => {
                    var _a, _b, _c, _d, _e, _f, _g;
                    const ticket_number = ticketNumbers[index];
                    const secret = process.env.EVENTO_JWT_SECRET;
                    const jwtPayload = {
                        ticketNumber: ticket_number,
                        orderNumber: order.orderId,
                        email: element === null || element === void 0 ? void 0 : element.email,
                        firstName: element === null || element === void 0 ? void 0 : element.firstName,
                        lastName: element === null || element === void 0 ? void 0 : element.lastName,
                        ticketType: (_a = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _a === void 0 ? void 0 : _a.id_short,
                    };
                    const token = jwt.sign(jwtPayload, secret, { noTimestamp: true });
                    const badgeCategory = ((_b = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _b === void 0 ? void 0 : _b.id_short) === "executive" ? "Official" :
                        ((_c = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _c === void 0 ? void 0 : _c.id_short) === "delegate" ? "Full Week" :
                            ((_d = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short) === "general_admission" ? "Visitor" :
                                (_e = element === null || element === void 0 ? void 0 : element.day) === null || _e === void 0 ? void 0 : _e.event;
                    ticketIds.push((_f = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _f === void 0 ? void 0 : _f.id);
                    mandrillEmailData.push({
                        email: element.email,
                        firstName: element.firstName,
                        lastName: element.lastName,
                        ticket_id: element === null || element === void 0 ? void 0 : element.ticket_id,
                        day: element === null || element === void 0 ? void 0 : element.day,
                        token,
                        inviteeName: (element === null || element === void 0 ? void 0 : element.inviteeName) || (body === null || body === void 0 ? void 0 : body.inviteeName)
                    });
                    return {
                        // ticket_id: element?.ticket_id?.id,
                        type: element.type || "others",
                        first_name: element.firstName || "-",
                        last_name: element.lastName || "-",
                        email: element.email || "-",
                        day: (element === null || element === void 0 ? void 0 : element.day) || {},
                        // order_id: order?.id,
                        ticket_number: ticket_number,
                        company: element.company || "-",
                        sector: element.sector || "-",
                        designation: element.designation || "-",
                        nationality: element.nationality || "-",
                        residance_country: element.residanceCountry || "-",
                        country_code: element.countryCode,
                        mobile: element.mobile || "-",
                        photo: element.photo,
                        order_number: order === null || order === void 0 ? void 0 : order.orderId,
                        tag: (element === null || element === void 0 ? void 0 : element.tag) || "-",
                        notes: (element === null || element === void 0 ? void 0 : element.note) || "-",
                        is_deleted: false,
                        status: "assigned",
                        published_at: new Date(),
                        created_at: new Date(),
                        emirate: element === null || element === void 0 ? void 0 : element.emirate,
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        token: token,
                        ticket_holder: body === null || body === void 0 ? void 0 : body.ticketHolder,
                        badge_category: (element === null || element === void 0 ? void 0 : element.badgeCategory) || badgeCategory,
                        day_short: (_g = element === null || element === void 0 ? void 0 : element.day) === null || _g === void 0 ? void 0 : _g.id_short,
                        invitee_name: (element === null || element === void 0 ? void 0 : element.inviteeName) || (body === null || body === void 0 ? void 0 : body.inviteeName),
                        allow_email: true,
                        is_sync_evento: false,
                        allow_chat: false
                    };
                });
                const createdTickets = await knex("ticket_masters")
                    .insert(ticketData)
                    .transacting(trx)
                    .returning("id");
                const ticket_ticket_master_data = [];
                const order_ticket_data = createdTickets.map((item, index) => {
                    ticket_ticket_master_data.push({
                        ticket_master_id: item.id,
                        ticket_id: ticketIds[index],
                        ticket_master_order: Number(index) + 1
                    });
                    return {
                        ticket_master_id: item.id,
                        order_id: order.id,
                        ticket_master_order: Number(index) + 1
                    };
                });
                // 4. create entries to ticket_masters_order_id_links table
                await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                // 5. create entries to ticket_masters_ticket_id_links table
                await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                // 6. Batch email sending
                const emailPromises = mandrillEmailData.map(async (ticket) => {
                    var _a, _b, _c, _d;
                    const mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                    const global_merge_vars = [
                        {
                            name: "FIRSTNAME",
                            content: ticket.firstName,
                        },
                        {
                            name: "ASSIGNEELINK",
                            content: `${process.env.WEB_URL}ticketing?token=${ticket.token}`,
                        },
                        {
                            name: "TICKETTYPE",
                            content: ((_b = (_a = ticket.day) === null || _a === void 0 ? void 0 : _a.event) === null || _b === void 0 ? void 0 : _b.toLowerCase()) === "other"
                                ? ticket.ticket_id.title
                                : `${(_c = ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.title}: ${(_d = ticket.day) === null || _d === void 0 ? void 0 : _d.event}`,
                        },
                    ];
                    if (ticket === null || ticket === void 0 ? void 0 : ticket.inviteeName) {
                        global_merge_vars.push({
                            name: "PARENTFULLNAME",
                            content: ticket.inviteeName,
                        });
                    }
                    else {
                        global_merge_vars.push({
                            name: "USERIMPORT",
                            content: true,
                        });
                    }
                    const emailPayload = {
                        key: process.env.MANDRILL_KEY,
                        template_name: process.env.ASSIGN_TICKET_TEMPLATE_NAME,
                        template_content: [],
                        message: {
                            to: [{
                                    email: ticket.email,
                                    name: ticket.firstName,
                                    type: "to",
                                }],
                            from_email: "donotreply@adfw.com",
                            from_name: "Abu Dhabi Finance Week",
                            global_merge_vars: global_merge_vars
                        },
                    };
                    return axios.post(mandrilURL, emailPayload);
                });
                // Wait for all emails to be sent
                await Promise.all(emailPromises);
                return new dataResponse_dto_1.DataResponseDto(createdTickets.length, "Imported tickets uploaded successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findExportData(params) {
        try {
            const { filters } = params;
            const data = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: {
                    is_deleted: false,
                    ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                },
                orderBy: { createdAt: "desc" },
                populate: {
                    ticket_id: true,
                    orderId: {
                        populate: {
                            discountCode: {
                                select: ["code"]
                            },
                            redeem_link: {
                                select: ["title"]
                            },
                            adgms: {
                                select: ["name"]
                            },
                            speaker: {
                                select: ["firstName", "lastName"]
                            }
                        }
                    },
                    sponsor: true,
                    adgm: true,
                    creator: {
                        select: ["firstName", "lastName"]
                    }
                },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Ticket master data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllTickets(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const { paidAmount, startDate, ticket_id_short, endDate, redeemId, ...otherFilters } = filters || {};
            let whereCase = {
                is_deleted: false,
                status: {
                    $ne: "draft",
                },
                ...(filters &&
                    Object.keys(otherFilters).length > 0 && { ...otherFilters }),
                ...(search &&
                    search.trim() && {
                    $or: [
                        { ticketNumber: { $containsi: search } },
                        { email: { $containsi: search } },
                        { firstName: { $containsi: search } },
                        { lastName: { $containsi: search } },
                        { tag: { $containsi: search } },
                        //  expect only two words
                        {
                            $and: [
                                { firstName: { $containsi: search.split(' ')[0] } },
                                { lastName: { $containsi: search.split(' ')[1] } },
                            ],
                        },
                    ],
                }),
                ...((filters === null || filters === void 0 ? void 0 : filters.startDate) &&
                    (filters === null || filters === void 0 ? void 0 : filters.endDate) && {
                    createdAt: {
                        $gte: (0, moment_1.default)(filters.startDate).startOf("day").toISOString(),
                        $lte: (0, moment_1.default)(filters.endDate).endOf("day").toISOString(),
                    },
                }),
                ...(ticket_id_short && {
                    ticket_id: {
                        id_short: {
                            $eq: ticket_id_short,
                        },
                    },
                })
            };
            const queryOptions = {
                where: whereCase,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
                populate: {
                    ticket_id: true,
                    orderId: {
                        where: {
                            ...(paidAmount && { paidAmount: paidAmount }),
                        },
                        populate: {
                            speaker: true,
                            creator: {
                                select: ["username", "firstName", "lastName"]
                            },
                            discountCode: {
                                select: ["code"]
                            },
                            redeem_link: {
                                select: ["title"]
                            },
                            adgms: {
                                select: ["name"]
                            }
                        },
                    },
                    sponsor: true,
                    adgm: true,
                    creator: {
                        select: ["username", "firstName", "lastName"]
                    },
                    modifiedBy: {
                        select: ["username", "firstName", "lastName"]
                    },
                },
            };
            const data = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany(queryOptions);
            const totalDataCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({ where: whereCase });
            const emailCountQuery = `
            SELECT 
              LOWER(email) AS email,
              COUNT(*) AS email_count
              FROM ticket_masters
              WHERE 
                  is_deleted = false 
                  AND (status IS NOT NULL AND status NOT IN ('refunded', 'draft', 'deleted', 'cancelled'))
              GROUP BY LOWER(email)
              HAVING COUNT(*) > 1;
        `;
            const emailCounts = await strapi.db.connection.raw(emailCountQuery);
            const duplicateEmails = new Set((emailCounts.rows || []).map(row => row.email.toLowerCase()));
            const modifiedData = data.map(ticket => ({
                ...ticket,
                hasDuplicates: duplicateEmails.has(ticket.email.toLowerCase())
            }));
            if (data) {
                const pageCount = Math.ceil(Number(totalDataCount) / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data: modifiedData,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: Number(totalDataCount),
                    },
                }, "Ticket data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async getTicketDataByOrderNumber(orderNumber) {
        try {
            const orderData = await strapi.db.query("api::order.order").findOne({
                where: {
                    orderId: orderNumber,
                    is_deleted: false
                }
            });
            if (!orderData) {
                return new dataResponse_dto_1.DataResponseDto(null, "No order found");
            }
            const data = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: { orderNumber, is_deleted: false,
                    status: {
                        $notIn: ["cancelled", "refunded", "deleted"]
                    }
                },
                orderBy: { id: "asc" },
                populate: {
                    ticket_id: {
                        select: ["title", "id_short"],
                    },
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Ticket master data fetched succes32sfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async getTicketByTicketNumber(ticketNumber, token) {
        try {
            const data = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: {
                    ticketNumber,
                    is_deleted: false,
                    ...(token && token.trim() && { token: token.trim() }),
                },
                populate: {
                    ticket_id: {
                        select: ["title", "id_short"],
                    },
                },
            });
            if (data.length) {
                return new dataResponse_dto_1.DataResponseDto({ data }, "Ticket master data fetched successfully");
            }
            else {
                return {
                    data: null,
                    message: "You don't have any ticket",
                    status: false,
                    statusCode: 409,
                };
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateByTicketNumber(body) {
        const updatedRecord = await strapi.db
            .query("api::ticket-master.ticket-master")
            .update({
            where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber, is_deleted: false },
            data: body,
        });
        return new dataResponse_dto_1.DataResponseDto(updatedRecord, "Ticket master data updated successfully");
    },
    async issueTicket(body) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        try {
            // const ticketData = await strapi.db
            //   .query("api::ticket-master.ticket-master")
            //   .findMany({
            //     where: {
            //       orderNumber: body?.OrderNumber,
            //       email: body?.email,
            //       status: "issued",
            //       is_deleted: false,
            //     },
            //   });
            // if (ticketData && ticketData.length > 0) {
            //   return {
            //     data: ticketData,
            //     status: false,
            //     message: `A ticket is already assigned to this email`,
            //     statusCode: 409,
            //   };
            // }
            const ticketData = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber, is_deleted: false },
                populate: {
                    ticket_id: true,
                    adgm: true
                },
            });
            if (!ticketData) {
                return new dataResponse_dto_1.DataResponseDto(null, "No ticket found");
            }
            if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.status) === "issued") {
                return new dataResponse_dto_1.DataResponseDto(null, "This ticket has already been issued");
            }
            // for adgm ticket without day value
            let badgeCategory = ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory;
            if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "adgm" && ((_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _a === void 0 ? void 0 : _a.id_short) === "single_day_delegate" && (ticketData === null || ticketData === void 0 ? void 0 : ticketData.dayShort) === null) {
                // update badge category
                if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory) === null) {
                    badgeCategory = (_b = body === null || body === void 0 ? void 0 : body.day) === null || _b === void 0 ? void 0 : _b.event;
                }
                const adgmData = await strapi.db
                    .query("api::adgm.adgm")
                    .findOne({
                    where: { id: (_c = ticketData === null || ticketData === void 0 ? void 0 : ticketData.adgm) === null || _c === void 0 ? void 0 : _c.id, is_deleted: false },
                    populate: true,
                });
                let remaining_resolve_count = adgmData === null || adgmData === void 0 ? void 0 : adgmData.remaining_resolve;
                let remaining_asset_abu_dhabi_count = adgmData === null || adgmData === void 0 ? void 0 : adgmData.remaining_asset_abu_dhabi;
                let remaining_fintech_abu_dhabi_count = adgmData === null || adgmData === void 0 ? void 0 : adgmData.remaining_fintech_abu_dhabi;
                let remaining_adsff_count = adgmData === null || adgmData === void 0 ? void 0 : adgmData.remaining_adsff;
                switch ((_d = body === null || body === void 0 ? void 0 : body.day) === null || _d === void 0 ? void 0 : _d.id_short) {
                    case "resolve":
                        remaining_resolve_count = Number(remaining_resolve_count) - 1;
                        break;
                    case "asset_abu_dhabi":
                        remaining_asset_abu_dhabi_count = Number(remaining_asset_abu_dhabi_count) - 1;
                        break;
                    case "fintech_abu_dhabi":
                        remaining_fintech_abu_dhabi_count = Number(remaining_fintech_abu_dhabi_count) - 1;
                        break;
                    case "adsff":
                        remaining_adsff_count = Number(remaining_adsff_count) - 1;
                        break;
                }
                let obj = {
                    remaining_resolve: Number(remaining_resolve_count),
                    remaining_asset_abu_dhabi: Number(remaining_asset_abu_dhabi_count),
                    remaining_fintech_abu_dhabi: Number(remaining_fintech_abu_dhabi_count),
                    remaining_adsff: Number(remaining_adsff_count),
                };
                await strapi.entityService.update("api::adgm.adgm", (_e = ticketData === null || ticketData === void 0 ? void 0 : ticketData.adgm) === null || _e === void 0 ? void 0 : _e.id, {
                    data: obj,
                });
            }
            let ticket = await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber, is_deleted: false },
                data: {
                    ...body,
                    dayShort: (_f = body === null || body === void 0 ? void 0 : body.day) === null || _f === void 0 ? void 0 : _f.id_short,
                    token: "",
                    badgeCategory
                },
                populate: {
                    ticket_id: true,
                },
            });
            let URL = process.env.EVENTO_VISITOR_INSERT;
            let reqObj = {
                OrderNumber: (body === null || body === void 0 ? void 0 : body.OrderNumber) || "",
                VisitorNumber: (body === null || body === void 0 ? void 0 : body.ticketNumber) || "",
                FirstName: (body === null || body === void 0 ? void 0 : body.firstName) || "",
                LastName: (body === null || body === void 0 ? void 0 : body.lastName) || "",
                Company: (body === null || body === void 0 ? void 0 : body.company) || "",
                JobTitle: (body === null || body === void 0 ? void 0 : body.designation) || "",
                Email: (body === null || body === void 0 ? void 0 : body.email) || "",
                Nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                BadgeCategory: badgeCategory,
                Country: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "",
                Mobile: `${(_g = body === null || body === void 0 ? void 0 : body.countryCode) === null || _g === void 0 ? void 0 : _g.replace("+", "")} ${body === null || body === void 0 ? void 0 : body.mobile} ` || "",
                SingleDay: ((_h = body === null || body === void 0 ? void 0 : body.day) === null || _h === void 0 ? void 0 : _h.event) || "Other",
                TicketType: (body === null || body === void 0 ? void 0 : body.ticketType) || "",
                Sector: (body === null || body === void 0 ? void 0 : body.sector) || "Other",
                City: (body === null || body === void 0 ? void 0 : body.nationality) || "",
                Payment: "Foc",
                Emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "",
                Photo: (body === null || body === void 0 ? void 0 : body.photo) || "",
                Quantiy: 1,
            };
            let externalRegister = await axios.post(URL, reqObj, {
                headers: {
                    Authorization: process.env.EVENTO_VISITOR_TOKEN,
                    "Content-Type": "application/json",
                },
            });
            if (body === null || body === void 0 ? void 0 : body.isBuyer) {
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                let obj = {
                    key: process.env.MANDRILL_KEY,
                    template_name: process.env.PARENT_BUYER_ISSUE_TICKET_TEMPLATE_NAME,
                    template_content: [],
                    message: {
                        to: [
                            {
                                email: body === null || body === void 0 ? void 0 : body.email,
                                name: body === null || body === void 0 ? void 0 : body.firstName,
                                type: "to",
                            },
                        ],
                        from_email: "donotreply@adfw.com",
                        from_name: "Abu Dhabi Finance Week",
                        // subject: "Your ADFW 2024 ticket is ready!",
                        global_merge_vars: [
                            {
                                name: "FIRSTNAME",
                                content: body === null || body === void 0 ? void 0 : body.firstName,
                            },
                            {
                                name: "FULLNAME",
                                content: `${body === null || body === void 0 ? void 0 : body.firstName} ${body === null || body === void 0 ? void 0 : body.lastName}`,
                            },
                            {
                                name: "EMAIL",
                                content: body === null || body === void 0 ? void 0 : body.email,
                            },
                            {
                                name: "TICKETTYPE",
                                content: ((_k = (_j = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _j === void 0 ? void 0 : _j.event) === null || _k === void 0 ? void 0 : _k.toLowerCase()) === "other"
                                    ? ticket.ticket_id.title
                                    : `${(_l = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _l === void 0 ? void 0 : _l.title}: ${(_m = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _m === void 0 ? void 0 : _m.event}`,
                                //body?.ticketType,
                            },
                            {
                                name: "TICKETID",
                                content: body === null || body === void 0 ? void 0 : body.ticketNumber,
                            },
                            {
                                name: "ORDERID",
                                content: body === null || body === void 0 ? void 0 : body.OrderNumber,
                            },
                            {
                                name: "DOWNLOADTICKET",
                                content: `${process.env.WEB_URL}ticket-download?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`,
                            },
                            {
                                name: "APPLEWALLET",
                                content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`,
                            },
                            {
                                name: "GOOGLEWALLET",
                                content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`,
                            },
                            {
                                name: "PARENTFULLNAME",
                                content: body === null || body === void 0 ? void 0 : body.parentName,
                            },
                        ],
                    },
                };
                await axios.post(mandrilURL, obj);
            }
            else {
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                let obj = {
                    key: process.env.MANDRILL_KEY,
                    template_name: process.env.ISSUE_TICKET_TEMPLATE_NAME,
                    template_content: [],
                    message: {
                        to: [
                            {
                                email: body === null || body === void 0 ? void 0 : body.email,
                                name: body === null || body === void 0 ? void 0 : body.firstName,
                                type: "to",
                            },
                        ],
                        from_email: "donotreply@adfw.com",
                        from_name: "Abu Dhabi Finance Week",
                        // subject: "ADFW 2024 ticket is ready!",
                        global_merge_vars: [
                            {
                                name: "FIRSTNAME",
                                content: body === null || body === void 0 ? void 0 : body.firstName,
                            },
                            {
                                name: "FULLNAME",
                                content: `${body === null || body === void 0 ? void 0 : body.firstName} ${body === null || body === void 0 ? void 0 : body.lastName}`,
                            },
                            {
                                name: "EMAIL",
                                content: body === null || body === void 0 ? void 0 : body.email,
                            },
                            {
                                name: "TICKETTYPE",
                                content: ((_p = (_o = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _o === void 0 ? void 0 : _o.event) === null || _p === void 0 ? void 0 : _p.toLowerCase()) === "other"
                                    ? ticket.ticket_id.title
                                    : `${(_q = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _q === void 0 ? void 0 : _q.title}: ${(_r = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _r === void 0 ? void 0 : _r.event}`,
                                // body?.ticketType,
                            },
                            {
                                name: "TICKETID",
                                content: body === null || body === void 0 ? void 0 : body.ticketNumber,
                            },
                            {
                                name: "ORDERID",
                                content: body === null || body === void 0 ? void 0 : body.OrderNumber,
                            },
                            {
                                name: "DOWNLOADTICKET",
                                content: `${process.env.WEB_URL}ticket-download?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`,
                            },
                            {
                                name: "APPLEWALLET",
                                content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`,
                            },
                            {
                                name: "GOOGLEWALLET",
                                content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${body === null || body === void 0 ? void 0 : body.ticketNumber}`
                            },
                        ],
                    },
                };
                await axios.post(mandrilURL, obj);
            }
            return new dataResponse_dto_1.DataResponseDto(externalRegister === null || externalRegister === void 0 ? void 0 : externalRegister.data, "Ticket issued");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async shareTicket(body) {
        var _a, _b, _c, _d, _e;
        try {
            const ticketData = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId, is_deleted: false },
                populate: true,
            });
            if (ticketData.status === "assigned" ||
                ticketData.status === "issued") {
                return new dataResponse_dto_1.DataResponseDto(null, "This ticket is already assigned or issued");
            }
            const secret = process.env.EVENTO_JWT_SECRET;
            const jwtPayload = {
                ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId,
                orderNumber: ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber,
                email: body === null || body === void 0 ? void 0 : body.email,
                firstName: body === null || body === void 0 ? void 0 : body.firstName,
                lastName: body === null || body === void 0 ? void 0 : body.lastName,
                ticketType: (_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _a === void 0 ? void 0 : _a.id_short,
            };
            const token = jwt.sign(jwtPayload, secret);
            await strapi.db.query("api::ticket-master.ticket-master").update({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId, is_deleted: false },
                data: { ...body, token, isSyncEvento: false },
            });
            let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
            let lastName = (ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName) ? ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName : "";
            let fullName = `${ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName} ${lastName}`;
            let obj = {
                key: process.env.MANDRILL_KEY,
                template_name: process.env.ASSIGN_TICKET_TEMPLATE_NAME,
                template_content: [],
                message: {
                    to: [
                        {
                            email: body === null || body === void 0 ? void 0 : body.email,
                            name: body === null || body === void 0 ? void 0 : body.firstName,
                            type: "to",
                        },
                    ],
                    from_email: "donotreply@adfw.com",
                    from_name: "Abu Dhabi Finance Week",
                    global_merge_vars: [
                        {
                            name: "FIRSTNAME",
                            content: body === null || body === void 0 ? void 0 : body.firstName,
                        },
                        {
                            name: "PARENTFULLNAME",
                            content: fullName.trim(),
                        },
                        {
                            name: "ASSIGNEELINK",
                            content: `${process.env.WEB_URL}ticketing?token=${token}`,
                        },
                        {
                            name: "TICKETTYPE",
                            content: ((_c = (_b = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _b === void 0 ? void 0 : _b.event) === null || _c === void 0 ? void 0 : _c.toLowerCase()) === "other"
                                ? ticketData.ticket_id.title
                                : `${(_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _d === void 0 ? void 0 : _d.title}: ${(_e = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _e === void 0 ? void 0 : _e.event}`,
                        },
                    ],
                },
            };
            await axios.post(mandrilURL, obj);
            return new dataResponse_dto_1.DataResponseDto(true, "Ticket shared successfully");
        }
        catch (error) {
            console.log(error);
            new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    // pending
    async recieveExistingTicket(body) {
        var _a, _b, _c, _d;
        try {
            const ticket = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: {
                    ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber,
                    is_deleted: false,
                },
                populate: {
                    ticket_id: true,
                },
            });
            let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
            let lastName = (ticket === null || ticket === void 0 ? void 0 : ticket.lastName) ? ticket === null || ticket === void 0 ? void 0 : ticket.lastName : "";
            let fullName = `${ticket === null || ticket === void 0 ? void 0 : ticket.firstName} ${lastName}`;
            let obj = {
                key: process.env.MANDRILL_KEY,
                template_name: process.env.ASSIGN_TICKET_TEMPLATE_NAME,
                template_content: [],
                message: {
                    to: [
                        {
                            email: body === null || body === void 0 ? void 0 : body.email,
                            name: body === null || body === void 0 ? void 0 : body.firstName,
                            type: "to",
                        },
                    ],
                    from_email: "donotreply@adfw.com",
                    from_name: "Abu Dhabi Finance Week",
                    global_merge_vars: [
                        {
                            name: "FIRSTNAME",
                            content: body === null || body === void 0 ? void 0 : body.firstName,
                        },
                        {
                            name: "PARENTFULLNAME",
                            content: fullName.trim(),
                        },
                        {
                            name: "ASSIGNEELINK",
                            content: `${process.env.WEB_URL}ticketing?token=${ticket === null || ticket === void 0 ? void 0 : ticket.token}`,
                        },
                        {
                            name: "TICKETTYPE",
                            content: ((_b = (_a = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _a === void 0 ? void 0 : _a.event) === null || _b === void 0 ? void 0 : _b.toLowerCase()) === "other"
                                ? ticket.ticket_id.title
                                : `${(_c = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.title}: ${(_d = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _d === void 0 ? void 0 : _d.event}`,
                        },
                    ],
                },
            };
            await axios.post(mandrilURL, obj);
            return "Ticket shared successfully";
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async reAssignTicket(body) {
        var _a, _b, _c, _d, _e;
        try {
            const ticketData = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId },
                populate: true,
            });
            if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.status) === "issued") {
                return new dataResponse_dto_1.DataResponseDto(null, "Ticket has already been issued");
            }
            const secret = process.env.EVENTO_JWT_SECRET;
            const jwtPayload = {
                ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId,
                orderNumber: ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber,
                email: body === null || body === void 0 ? void 0 : body.email,
                firstName: body === null || body === void 0 ? void 0 : body.firstName,
                lastName: body === null || body === void 0 ? void 0 : body.lastName,
                ticketType: (_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _a === void 0 ? void 0 : _a.id_short,
            };
            const token = jwt.sign(jwtPayload, secret);
            const updatedTicket = await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { ticketNumber: body === null || body === void 0 ? void 0 : body.ticketId, is_deleted: false },
                data: { ...body, token: token, status: "reassigned", isSyncEvento: false },
            });
            const orderData = await strapi.db.query("api::order.order").findOne({
                where: { orderId: ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber },
            });
            let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
            let lastName = (orderData === null || orderData === void 0 ? void 0 : orderData.lastName) ? orderData === null || orderData === void 0 ? void 0 : orderData.lastName : "";
            let fullName = `${orderData === null || orderData === void 0 ? void 0 : orderData.firstName} ${lastName}`;
            let obj = {
                key: process.env.MANDRILL_KEY,
                template_name: process.env.ASSIGN_TICKET_TEMPLATE_NAME,
                template_content: [],
                message: {
                    to: [
                        {
                            email: updatedTicket === null || updatedTicket === void 0 ? void 0 : updatedTicket.email,
                            name: updatedTicket === null || updatedTicket === void 0 ? void 0 : updatedTicket.firstName,
                            type: "to",
                        },
                    ],
                    from_email: "donotreply@adfw.com",
                    from_name: "Abu Dhabi Finance Week",
                    global_merge_vars: [
                        {
                            name: "FIRSTNAME",
                            content: updatedTicket === null || updatedTicket === void 0 ? void 0 : updatedTicket.firstName,
                        },
                        {
                            name: "PARENTFULLNAME",
                            content: fullName.trim(),
                        },
                        {
                            name: "ASSIGNEELINK",
                            content: `${process.env.WEB_URL}ticketing?token=${token}`,
                        },
                        {
                            name: "TICKETTYPE",
                            content: ((_c = (_b = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _b === void 0 ? void 0 : _b.event) === null || _c === void 0 ? void 0 : _c.toLowerCase()) === "other"
                                ? ticketData.ticket_id.title
                                : `${(_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _d === void 0 ? void 0 : _d.title}: ${(_e = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _e === void 0 ? void 0 : _e.event}`,
                        },
                    ],
                },
            };
            await axios.post(mandrilURL, obj);
            return new dataResponse_dto_1.DataResponseDto(updatedTicket, "Ticket re-assigned successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id, userId) {
        try {
            const data = await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                    modifiedBy: userId,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Ticket-master data deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateChatOption(id) {
        try {
            const data = await strapi.db.query("api::ticket-master.ticket-master").findOne({
                where: { id, is_deleted: false }
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null, "No data found");
            }
            await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { id, is_deleted: false },
                data: {
                    allowChat: !data.allowChat
                },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Chat option updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateTermsAgreed(id) {
        try {
            const data = await strapi.db.query("api::ticket-master.ticket-master").findOne({
                where: { id, is_deleted: false }
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null, "No data found");
            }
            await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { id, is_deleted: false },
                data: {
                    isTermsAgreed: !data.isTermsAgreed
                },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Agree terms option updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async approveTicketByAdmin(body) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        try {
            if (body.ids.length === 0) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please select tickets to approve");
            }
            const updatedArray = [];
            const failedArray = [];
            let udpatedCount = 0;
            let failedCount = 0;
            let reqCount = body.ids.length;
            for (const element of body.ids) {
                // fetch the data with id
                const ticketData = await strapi.db
                    .query("api::ticket-master.ticket-master")
                    .findOne({
                    where: { id: element, is_deleted: false },
                    populate: true,
                });
                if (ticketData.status === "issued") {
                    failedCount++;
                    failedArray.push(element);
                }
                else {
                    if (body === null || body === void 0 ? void 0 : body.isUBS) {
                        await strapi.db.query("api::ticket-master.ticket-master").update({
                            where: { id: element, is_deleted: false },
                            data: { status: "issued", modifiedBy: body === null || body === void 0 ? void 0 : body.userId }
                        });
                        let URL = process.env.EVENTO_VISITOR_INSERT;
                        let reqObj = {
                            OrderNumber: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber) || "",
                            VisitorNumber: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber) || "",
                            FirstName: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName) || "",
                            LastName: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName) || "",
                            Company: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.company) || "",
                            JobTitle: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.designation) || "",
                            Email: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.email) || "",
                            Nationality: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.nationality) || "",
                            BadgeCategory: ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory,
                            Country: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.residanceCountry) || "",
                            Mobile: `${(_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.countryCode) === null || _a === void 0 ? void 0 : _a.replace("+", "")} ${ticketData === null || ticketData === void 0 ? void 0 : ticketData.mobile} ` || "",
                            SingleDay: ((_b = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _b === void 0 ? void 0 : _b.event) || "Other",
                            TicketType: ((_c = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _c === void 0 ? void 0 : _c.event) || "",
                            Sector: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.sector) || "Other",
                            City: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.nationality) || "",
                            Payment: "Foc",
                            Emirate: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.emirate) || "",
                            Photo: (ticketData === null || ticketData === void 0 ? void 0 : ticketData.photo) || "",
                            Quantiy: 1,
                        };
                        await axios.post(URL, reqObj, {
                            headers: {
                                Authorization: process.env.EVENTO_VISITOR_TOKEN,
                                "Content-Type": "application/json",
                            },
                        });
                    }
                    else {
                        const secret = process.env.EVENTO_JWT_SECRET;
                        const jwtPayload = {
                            ticketNumber: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
                            orderNumber: ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber,
                            email: ticketData === null || ticketData === void 0 ? void 0 : ticketData.email,
                            firstName: ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName,
                            lastName: ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName,
                            ticketType: (_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short,
                            chooseSingleDay: ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "adgm" && ((_e = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _e === void 0 ? void 0 : _e.id_short) === "single_day_delegate" &&
                                (ticketData === null || ticketData === void 0 ? void 0 : ticketData.dayShort) === null) ? true : false
                        };
                        const token = jwt.sign(jwtPayload, secret, { noTimestamp: true });
                        if (body === null || body === void 0 ? void 0 : body.approve) {
                            await strapi.db.query("api::ticket-master.ticket-master").update({
                                where: { id: element, is_deleted: false },
                                data: { status: "assigned", token, modifiedBy: body === null || body === void 0 ? void 0 : body.userId, isSyncEvento: false },
                                populate: {
                                    orderId: true,
                                },
                            });
                        }
                        ;
                        // send mail
                        let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                        let lasName = ((_f = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _f === void 0 ? void 0 : _f.lastName) ? (_g = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _g === void 0 ? void 0 : _g.lastName : "";
                        let firstName = (_h = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _h === void 0 ? void 0 : _h.firstName;
                        let fullName = `${firstName} ${lasName}`;
                        let template_name = process.env.ASSIGN_TICKET_TEMPLATE_NAME;
                        if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "adgm") {
                            fullName = "ADGM";
                            if (((_j = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _j === void 0 ? void 0 : _j.id_short) === "general_admission") {
                                template_name = process.env.ASSIGN_TICKET_TEMPLATE_NAME;
                            }
                            else if (((_k = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _k === void 0 ? void 0 : _k.id_short) === "single_day_delegate" && (ticketData === null || ticketData === void 0 ? void 0 : ticketData.dayShort) === "resolve") {
                                template_name = process.env.ADGM_RESOLVE_INVITE_TEMPLATE;
                            }
                            else if (((_l = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _l === void 0 ? void 0 : _l.id_short) === "single_day_delegate" && (ticketData === null || ticketData === void 0 ? void 0 : ticketData.dayShort) !== "resolve") {
                                template_name = process.env.ADGM_SINGLE_DAY_INVITE_TEMPLATE;
                            }
                            else if (((_m = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _m === void 0 ? void 0 : _m.id_short) === "executive") {
                                template_name = process.env.ADGM_EXECUTIVE_INVITE_TEMPLATE;
                            }
                            else if (((_o = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _o === void 0 ? void 0 : _o.id_short) === "delegate") {
                                template_name = process.env.ADGM_FULL_WEEK_INVITE_TEMPLATE;
                            }
                        }
                        let obj = {
                            key: process.env.MANDRILL_KEY,
                            template_name: template_name,
                            template_content: [],
                            message: {
                                to: [
                                    {
                                        email: ticketData === null || ticketData === void 0 ? void 0 : ticketData.email,
                                        name: ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName,
                                        type: "to",
                                    },
                                ],
                                from_email: "donotreply@adfw.com",
                                from_name: "Abu Dhabi Finance Week",
                                global_merge_vars: [
                                    {
                                        name: "FIRSTNAME",
                                        content: ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName,
                                    },
                                    {
                                        name: "PARENTFULLNAME",
                                        content: fullName.trim(),
                                    },
                                    ...((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "adgm" &&
                                        ((_p = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _p === void 0 ? void 0 : _p.id_short) === "delegate" &&
                                        ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory) === "ADGM" ||
                                            (ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory) === "ADGM Organiser" ||
                                            (ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory) === "ADGM Protocol" ||
                                            (ticketData === null || ticketData === void 0 ? void 0 : ticketData.badgeCategory) === "Media")
                                        ? [{ name: "FIRSTDAY", content: true }]
                                        : []),
                                    {
                                        name: "ASSIGNEELINK",
                                        content: `${process.env.WEB_URL}ticketing?token=${token}`,
                                    },
                                    {
                                        name: "TICKETTYPE",
                                        content: (((_r = (_q = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _q === void 0 ? void 0 : _q.event) === null || _r === void 0 ? void 0 : _r.toLowerCase()) === "other" || (ticketData === null || ticketData === void 0 ? void 0 : ticketData.dayShort) === null)
                                            ? ticketData.ticket_id.title
                                            : `${(_s = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _s === void 0 ? void 0 : _s.title}: ${(_t = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _t === void 0 ? void 0 : _t.event}`,
                                    },
                                ],
                            },
                        };
                        await axios.post(mandrilURL, obj);
                    }
                    udpatedCount++;
                    updatedArray.push(element);
                }
            }
            let res = {
                reqCount,
                udpatedCount,
                failedCount,
                success: updatedArray,
                failed: failedArray,
            };
            return new dataResponse_dto_1.DataResponseDto(res, "Ticket approved successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    // vvip and excel
    async uploadVipTickets(body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b;
                const knex = strapi.db.connection;
                if (!(body === null || body === void 0 ? void 0 : body.ticketData) || ((_a = body === null || body === void 0 ? void 0 : body.ticketData) === null || _a === void 0 ? void 0 : _a.length) === 0)
                    return new dataResponse_dto_1.DataResponseDto(null, "No ticket data found");
                if (!(body === null || body === void 0 ? void 0 : body.userId)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please provide user id");
                }
                let generatedOrderId = await generateOrderNum("other");
                // 1. create order 
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: generatedOrderId,
                        type: "others",
                        eventDate: new Date(),
                        firstName: body === null || body === void 0 ? void 0 : body.firstName,
                        lastName: body === null || body === void 0 ? void 0 : body.lastName,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        sector: body === null || body === void 0 ? void 0 : body.sector,
                        designation: body === null || body === void 0 ? void 0 : body.designation,
                        nationality: body === null || body === void 0 ? void 0 : body.nationality,
                        residanceCountry: body === null || body === void 0 ? void 0 : body.residanceCountry,
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        mobile: body === null || body === void 0 ? void 0 : body.mobile,
                        photo: (body === null || body === void 0 ? void 0 : body.photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        ticketCount: ((_b = body === null || body === void 0 ? void 0 : body.ticketData) === null || _b === void 0 ? void 0 : _b.length) || 0,
                        discountAmount: 0,
                        totalAmount: 0,
                        paidAmount: 0,
                        is_discounted: false,
                        publishedAt: new Date(),
                        emirate: body === null || body === void 0 ? void 0 : body.emirate,
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Free",
                        userType: body === null || body === void 0 ? void 0 : body.ticketHolder,
                        creator: body === null || body === void 0 ? void 0 : body.userId,
                    },
                    transacting: trx,
                });
                // 2. generate ticket numbers
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.length);
                const { ticketData, visitorInserData, ticketIds, mandrillEmailData } = body === null || body === void 0 ? void 0 : body.ticketData.reduce((acc, element, index) => {
                    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
                    const ticket_number = ticketNumbers[index];
                    const orderNumber = (order === null || order === void 0 ? void 0 : order.orderId) || "";
                    const badgeCategory = {
                        executive: "Official",
                        delegate: "Full Week",
                        general_admission: "Visitor"
                    }[(_a = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _a === void 0 ? void 0 : _a.id_short] || ((_b = element === null || element === void 0 ? void 0 : element.day) === null || _b === void 0 ? void 0 : _b.event) || "Official";
                    // Ensure all properties are set up
                    acc.ticketIds.push(((_c = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _c === void 0 ? void 0 : _c.id) || "");
                    if (element.allowEmail) {
                        acc.mandrillEmailData.push({
                            email: (element === null || element === void 0 ? void 0 : element.email) || "",
                            firstName: (element === null || element === void 0 ? void 0 : element.firstName) || "",
                            lastName: (element === null || element === void 0 ? void 0 : element.lastName) || "",
                            ticket_id: (element === null || element === void 0 ? void 0 : element.ticket_id) || "",
                            day: (element === null || element === void 0 ? void 0 : element.day) || null,
                            ticketNumber: ticket_number,
                            orderNumber: orderNumber,
                            ticketName: ((_d = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short) === "executive" ? "Executive" : ((_e = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _e === void 0 ? void 0 : _e.id_short) === "delegate" ? "Full Week" :
                                ((_f = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _f === void 0 ? void 0 : _f.id_short) === "general_admission" ? "Venture Park" : "Single Day"
                        });
                    }
                    acc.visitorInserData.push({
                        OrderNumber: orderNumber,
                        VisitorNumber: ticket_number,
                        FirstName: (element === null || element === void 0 ? void 0 : element.firstName) || "",
                        LastName: (element === null || element === void 0 ? void 0 : element.lastName) || "",
                        Company: (element === null || element === void 0 ? void 0 : element.company) || "",
                        JobTitle: (element === null || element === void 0 ? void 0 : element.designation) || "",
                        Email: (element === null || element === void 0 ? void 0 : element.email) || "",
                        Nationality: (element === null || element === void 0 ? void 0 : element.nationality) || "",
                        BadgeCategory: (element === null || element === void 0 ? void 0 : element.badgeCategory) || badgeCategory,
                        Country: (element === null || element === void 0 ? void 0 : element.residanceCountry) || "",
                        Mobile: `${((_g = element === null || element === void 0 ? void 0 : element.countryCode) === null || _g === void 0 ? void 0 : _g.replace("+", "")) || ""} ${(element === null || element === void 0 ? void 0 : element.mobile) || ""}`,
                        SingleDay: ((_h = element === null || element === void 0 ? void 0 : element.day) === null || _h === void 0 ? void 0 : _h.event) || "Other",
                        TicketType: (element === null || element === void 0 ? void 0 : element.ticketType) || "",
                        Sector: (element === null || element === void 0 ? void 0 : element.sector) || "Other",
                        City: (element === null || element === void 0 ? void 0 : element.nationality) || "",
                        Payment: "Foc",
                        Emirate: (element === null || element === void 0 ? void 0 : element.emirate) || "",
                        Photo: (element === null || element === void 0 ? void 0 : element.photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        Quantity: 1
                    });
                    acc.ticketData.push({
                        type: (element === null || element === void 0 ? void 0 : element.type) || "others",
                        first_name: (element === null || element === void 0 ? void 0 : element.firstName) || "",
                        last_name: (element === null || element === void 0 ? void 0 : element.lastName) || "",
                        email: (element === null || element === void 0 ? void 0 : element.email) || "",
                        day: (element === null || element === void 0 ? void 0 : element.day) || null,
                        ticket_number,
                        company: (element === null || element === void 0 ? void 0 : element.company) || "",
                        sector: (element === null || element === void 0 ? void 0 : element.sector) || "",
                        designation: (element === null || element === void 0 ? void 0 : element.designation) || "",
                        nationality: (element === null || element === void 0 ? void 0 : element.nationality) || "",
                        residance_country: (element === null || element === void 0 ? void 0 : element.residanceCountry) || "",
                        country_code: (element === null || element === void 0 ? void 0 : element.countryCode) || "",
                        mobile: (element === null || element === void 0 ? void 0 : element.mobile) || "",
                        photo: (element === null || element === void 0 ? void 0 : element.photo) || "",
                        order_number: orderNumber,
                        tag: (element === null || element === void 0 ? void 0 : element.tag) || "",
                        notes: (element === null || element === void 0 ? void 0 : element.note) || "",
                        is_deleted: false,
                        status: "issued",
                        published_at: new Date(),
                        created_at: new Date(),
                        emirate: (element === null || element === void 0 ? void 0 : element.emirate) || "",
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        ticket_holder: body === null || body === void 0 ? void 0 : body.ticketHolder,
                        badge_category: (element === null || element === void 0 ? void 0 : element.badgeCategory) || badgeCategory,
                        day_short: ((_j = element === null || element === void 0 ? void 0 : element.day) === null || _j === void 0 ? void 0 : _j.id_short) || "",
                        allow_email: (element === null || element === void 0 ? void 0 : element.allowEmail) || false,
                        allow_chat: false
                    });
                    return acc;
                }, { ticketData: [], visitorInserData: [], ticketIds: [], mandrillEmailData: [] });
                // 3. Bulk create tickets 
                const createdTickets = await knex("ticket_masters")
                    .insert(ticketData)
                    .transacting(trx)
                    .returning("id");
                const ticket_ticket_master_data = [];
                const order_ticket_data = createdTickets.map((item, index) => {
                    ticket_ticket_master_data.push({
                        ticket_master_id: item.id,
                        ticket_id: ticketIds[index],
                        ticket_master_order: Number(index) + 1
                    });
                    return {
                        ticket_master_id: item.id,
                        order_id: order.id,
                        ticket_master_order: Number(index) + 1
                    };
                });
                // 4. create entries to ticket_masters_order_id_links table
                await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                // 5. create entries to ticket_masters_ticket_id_links table
                await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                // 6. Batch email sending
                if (visitorInserData.length) {
                    const emailPromises = mandrillEmailData.map(async (item) => {
                        var _a, _b, _c;
                        const mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                        const emailPayload = {
                            key: process.env.MANDRILL_KEY,
                            template_name: process.env.ISSUE_TICKET_TEMPLATE_NAME,
                            template_content: [],
                            message: {
                                to: [{
                                        email: item.email,
                                        name: item.firstName,
                                        type: "to",
                                    }],
                                from_email: "donotreply@adfw.com",
                                from_name: "Abu Dhabi Finance Week",
                                global_merge_vars: [
                                    {
                                        name: "FIRSTNAME",
                                        content: item.firstName,
                                    },
                                    {
                                        name: "FULLNAME",
                                        content: `${item === null || item === void 0 ? void 0 : item.firstName} ${item === null || item === void 0 ? void 0 : item.lastName}`,
                                    },
                                    {
                                        name: "EMAIL",
                                        content: item === null || item === void 0 ? void 0 : item.email,
                                    },
                                    {
                                        name: "TICKETTYPE",
                                        content: ((_b = (_a = item === null || item === void 0 ? void 0 : item.day) === null || _a === void 0 ? void 0 : _a.event) === null || _b === void 0 ? void 0 : _b.toLowerCase()) !== "other"
                                            ? `${item === null || item === void 0 ? void 0 : item.ticketName}: ${(_c = item === null || item === void 0 ? void 0 : item.day) === null || _c === void 0 ? void 0 : _c.event}`
                                            : `${item === null || item === void 0 ? void 0 : item.ticketName}`,
                                    },
                                    {
                                        name: "TICKETID",
                                        content: item === null || item === void 0 ? void 0 : item.ticketNumber,
                                    },
                                    {
                                        name: "ORDERID",
                                        content: item === null || item === void 0 ? void 0 : item.orderNumber,
                                    },
                                    {
                                        name: "DOWNLOADTICKET",
                                        content: `${process.env.WEB_URL}ticket-download?ticketNumber=${item === null || item === void 0 ? void 0 : item.ticketNumber}`,
                                    },
                                    {
                                        name: "APPLEWALLET",
                                        content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${item === null || item === void 0 ? void 0 : item.ticketNumber}`,
                                    },
                                    {
                                        name: "GOOGLEWALLET",
                                        content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${item === null || item === void 0 ? void 0 : item.ticketNumber}`
                                    },
                                ],
                            },
                        };
                        return axios.post(mandrilURL, emailPayload);
                    });
                    await Promise.all(emailPromises);
                }
                // 7. evento insert
                if (visitorInserData.length) {
                    const eventoPromises = visitorInserData.map(async (element) => {
                        let URL = process.env.EVENTO_VISITOR_INSERT;
                        return axios.post(URL, element, {
                            headers: {
                                Authorization: process.env.EVENTO_VISITOR_TOKEN,
                                "Content-Type": "application/json",
                            },
                        });
                    });
                    await Promise.all(eventoPromises);
                }
                return new dataResponse_dto_1.DataResponseDto(createdTickets.length, "Tickets uploaded successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateTicketStatus(ticketNumber, status, userAccess, userId) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
                const ticketData = await strapi.db
                    .query("api::ticket-master.ticket-master")
                    .findOne({
                    where: {
                        ticketNumber,
                        is_deleted: false,
                        status: {
                            $notIn: ["refunded", "cancelled", "deleted", "draft"],
                        },
                    },
                    populate: {
                        ticket_id: true,
                        orderId: {
                            populate: {
                                sponsors: true,
                                adgms: true,
                                speaker: true,
                                redeem_link: true,
                            },
                        },
                    },
                });
                if (!ticketData) {
                    return new dataResponse_dto_1.DataResponseDto(null, `No ticket found for this ticket number ${ticketNumber}`);
                }
                if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "regular") {
                    return new dataResponse_dto_1.DataResponseDto(null, "Ticket cannot be updated as it is a paid ticket.");
                }
                let cancelRole = 29;
                let deleteRole = 30;
                const hasDeleteAccess = userAccess === null || userAccess === void 0 ? void 0 : userAccess.includes(deleteRole);
                const hasCancelAccess = userAccess === null || userAccess === void 0 ? void 0 : userAccess.includes(cancelRole);
                if (!hasDeleteAccess && status === "Deleted") {
                    return new dataResponse_dto_1.DataResponseDto(null, "You don't have delete access");
                }
                if (!hasCancelAccess && status === "Cancelled") {
                    return new dataResponse_dto_1.DataResponseDto(null, "You don't have cancel access");
                }
                let ticketObj = {
                    status: status === "Deleted" ? "deleted" : "cancelled",
                    token: "",
                    modifiedBy: userId,
                    allowChat: false
                };
                if (status === "Deleted") {
                    ticketObj.is_deleted = true;
                }
                const dbResponse = await strapi.db
                    .query("api::ticket-master.ticket-master")
                    .update({
                    where: { ticketNumber },
                    data: ticketObj,
                });
                let eventoObj = {
                    OrderNumber: "",
                    TicketId: ticketNumber,
                    Status: 0,
                };
                let url = process.env.EVENTO_UPDATE_STATUS;
                let eventoUpdatedData = await axios.post(url, eventoObj, {
                    headers: {
                        Authorization: process.env.EVENTO_VISITOR_TOKEN,
                        "Content-Type": "application/json",
                    },
                });
                // Handle SendBird user deletion
                if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.status) === "issued" && ticketData.ticket_id.id_short !== "general_admission") {
                    try {
                        const senbirdUrl = `https://api-${process.env.SENBIRD_APP_ID}.sendbird.com/v3/users/${ticketNumber}`;
                        const senbirdUser = await axios.get(senbirdUrl, {
                            headers: {
                                "Api-Token": process.env.SEND_BIRD_API_TOKEN,
                                "Content-Type": "application/json",
                            },
                        });
                        // Only attempt deletion if user exists
                        if ((senbirdUser === null || senbirdUser === void 0 ? void 0 : senbirdUser.data) && !((_a = senbirdUser === null || senbirdUser === void 0 ? void 0 : senbirdUser.data) === null || _a === void 0 ? void 0 : _a.error)) {
                            await axios.delete(senbirdUrl, {
                                headers: {
                                    "Api-Token": process.env.SEND_BIRD_API_TOKEN,
                                    "Content-Type": "application/json",
                                },
                            });
                        }
                    }
                    catch (error) {
                        // Ignore SendBird errors - user might not exist
                        console.log("SendBird operation failed:", error.message);
                    }
                }
                let remaining_general_admission_count = 0;
                let remaining_executive_count = 0;
                let remaining_delegate_count = 0;
                let remaining_padock_club_count = 0;
                let remaining_single_day_delegate_count = 0;
                let remaining_resolve_count = 0;
                let remaining_asset_abu_dhabi_count = 0;
                let remaining_fintech_abu_dhabi_count = 0;
                let remaining_adsff_count = 0;
                function updateRemainingCount(ticketIdShort, dayIdShort) {
                    switch (ticketIdShort) {
                        case "general_admission":
                            remaining_general_admission_count += 1;
                            break;
                        case "executive":
                            remaining_executive_count += 1;
                            break;
                        case "delegate":
                            remaining_delegate_count += 1;
                            break;
                        case "padock_club":
                            remaining_padock_club_count += 1;
                            break;
                        case "single_day_delegate":
                            remaining_single_day_delegate_count += 1;
                            switch (dayIdShort) {
                                case "resolve":
                                    remaining_resolve_count += 1;
                                    break;
                                case "asset_abu_dhabi":
                                    remaining_asset_abu_dhabi_count += 1;
                                    break;
                                case "fintech_abu_dhabi":
                                    remaining_fintech_abu_dhabi_count += 1;
                                    break;
                                case "adsff":
                                    remaining_adsff_count += 1;
                                    break;
                            }
                            break;
                    }
                }
                updateRemainingCount((_b = ticketData.ticket_id) === null || _b === void 0 ? void 0 : _b.id_short, (_c = ticketData.day) === null || _c === void 0 ? void 0 : _c.id_short);
                if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "sponsor") {
                    const sponsorData = await strapi
                        .query("api::sponsor.sponsor")
                        .findOne({
                        where: { id: (_e = (_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _d === void 0 ? void 0 : _d.sponsors[0]) === null || _e === void 0 ? void 0 : _e.id },
                    });
                    remaining_general_admission_count =
                        Number(remaining_general_admission_count) +
                            Number(sponsorData.remaining_general_admission_count);
                    remaining_executive_count =
                        Number(remaining_executive_count) +
                            Number(sponsorData.remaining_executive_count);
                    remaining_delegate_count =
                        Number(remaining_delegate_count) +
                            Number(sponsorData.remaining_delegate_count);
                    remaining_padock_club_count =
                        Number(remaining_padock_club_count) +
                            Number(sponsorData.remaining_padock_club_count);
                    remaining_single_day_delegate_count =
                        Number(remaining_single_day_delegate_count) +
                            Number(sponsorData.remaining_single_day_delegate_count);
                    remaining_resolve_count =
                        Number(remaining_resolve_count) +
                            Number(sponsorData.remaining_resolve_count);
                    remaining_asset_abu_dhabi_count =
                        Number(remaining_asset_abu_dhabi_count) +
                            Number(sponsorData.remaining_asset_abu_dhabi_count);
                    remaining_fintech_abu_dhabi_count =
                        Number(remaining_fintech_abu_dhabi_count) +
                            Number(sponsorData.remaining_fintech_abu_dhabi_count);
                    remaining_adsff_count =
                        Number(remaining_adsff_count) +
                            Number(sponsorData.remaining_adsff_count);
                    let limitObj = {
                        remaining_executive_count: remaining_executive_count,
                        remaining_delegate_count: remaining_delegate_count,
                        remaining_padock_club_count: remaining_padock_club_count,
                        remaining_general_admission_count: remaining_general_admission_count,
                        remaining_single_day_delegate_count: remaining_single_day_delegate_count,
                        remaining_resolve_count: remaining_resolve_count,
                        remaining_asset_abu_dhabi_count: remaining_asset_abu_dhabi_count,
                        remaining_fintech_abu_dhabi_count: remaining_fintech_abu_dhabi_count,
                        remaining_adsff_count: remaining_adsff_count,
                    };
                    // update sponsor count
                    await strapi.entityService.update("api::sponsor.sponsor", sponsorData.id, {
                        data: limitObj,
                        transacting: trx,
                    });
                }
                else if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "redeem_link") {
                    const redeemLinkData = await strapi
                        .query("api::redeem-link.redeem-link")
                        .findOne({
                        where: { id: (_g = (_f = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _f === void 0 ? void 0 : _f.redeem_link) === null || _g === void 0 ? void 0 : _g.id },
                    });
                    let resolve_remaining_count = Number(redeemLinkData.resolve_remaining_count);
                    let asset_remaining_count = Number(redeemLinkData.asset_remaining_count);
                    let fintech_remaining_count = Number(redeemLinkData.fintech_remaining_count);
                    let adsff_remaining_count = Number(redeemLinkData.adsff_remaining_count);
                    let total_remaining_count = Number(redeemLinkData.total_remaining_count) + 1;
                    if (((_h = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _h === void 0 ? void 0 : _h.id_short) === "resolve") {
                        resolve_remaining_count = Number(resolve_remaining_count) + 1;
                    }
                    else if (((_j = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _j === void 0 ? void 0 : _j.id_short) === "asset_abu_dhabi") {
                        asset_remaining_count = Number(asset_remaining_count) + 1;
                    }
                    else if (((_k = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _k === void 0 ? void 0 : _k.id_short) === "fintech_abu_dhabi") {
                        fintech_remaining_count = Number(fintech_remaining_count) + 1;
                    }
                    else if (((_l = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _l === void 0 ? void 0 : _l.id_short) === "adsff") {
                        adsff_remaining_count = Number(adsff_remaining_count) + 1;
                    }
                    let redeemObj = {
                        total_remaining_count: Number(total_remaining_count),
                        resolve_remaining_count: Number(resolve_remaining_count),
                        asset_remaining_count: Number(asset_remaining_count),
                        fintech_remaining_count: Number(fintech_remaining_count),
                        adsff_remaining_count: Number(adsff_remaining_count),
                    };
                    // update redeem-link count
                    await strapi.entityService.update("api::redeem-link.redeem-link", redeemLinkData.id, {
                        data: redeemObj,
                        transacting: trx,
                    });
                }
                else if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "adgm") {
                    const adgmData = await strapi.query("api::adgm.adgm").findOne({
                        where: { id: (_o = (_m = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _m === void 0 ? void 0 : _m.adgms[0]) === null || _o === void 0 ? void 0 : _o.id },
                    });
                    remaining_general_admission_count =
                        Number(remaining_general_admission_count) +
                            Number(adgmData.remainig_general_admission);
                    remaining_executive_count =
                        Number(remaining_executive_count) +
                            Number(adgmData.remaining_executive);
                    remaining_delegate_count =
                        Number(remaining_delegate_count) +
                            Number(adgmData.remaining_delegate);
                    remaining_padock_club_count =
                        Number(remaining_padock_club_count) +
                            Number(adgmData.remaining_paddock);
                    remaining_single_day_delegate_count =
                        Number(remaining_single_day_delegate_count) +
                            Number(adgmData.remaining_single_day);
                    remaining_resolve_count =
                        Number(remaining_resolve_count) +
                            Number(adgmData.remaining_resolve);
                    remaining_asset_abu_dhabi_count =
                        Number(remaining_asset_abu_dhabi_count) +
                            Number(adgmData.remaining_asset_abu_dhabi);
                    remaining_fintech_abu_dhabi_count =
                        Number(remaining_fintech_abu_dhabi_count) +
                            Number(adgmData.remaining_fintech_abu_dhabi);
                    remaining_adsff_count =
                        Number(remaining_adsff_count) + Number(adgmData.remaining_adsff);
                    let adgmObj = {
                        remainig_general_admission: remaining_general_admission_count,
                        remaining_executive: remaining_executive_count,
                        remaining_delegate: remaining_delegate_count,
                        remaining_paddock: remaining_padock_club_count,
                        remaining_single_day: remaining_single_day_delegate_count,
                        remaining_resolve: remaining_resolve_count,
                        remaining_asset_abu_dhabi: remaining_asset_abu_dhabi_count,
                        remaining_fintech_abu_dhabi: remaining_fintech_abu_dhabi_count,
                        remaining_adsff: remaining_adsff_count,
                    };
                    // update adgm count
                    await strapi.entityService.update("api::adgm.adgm", adgmData.id, {
                        data: adgmObj,
                        transacting: trx,
                    });
                }
                else if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketHolder) === "speaker") {
                    const speakerData = await strapi
                        .query("api::speaker.speaker")
                        .findOne({
                        where: { id: (_q = (_p = ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderId) === null || _p === void 0 ? void 0 : _p.speaker) === null || _q === void 0 ? void 0 : _q.id },
                    });
                    remaining_general_admission_count =
                        Number(remaining_general_admission_count) +
                            Number(speakerData.remaining_general_admission);
                    remaining_executive_count =
                        Number(remaining_executive_count) +
                            Number(speakerData.remaining_executive);
                    remaining_delegate_count =
                        Number(remaining_delegate_count) +
                            Number(speakerData.remaining_delegate);
                    remaining_padock_club_count =
                        Number(remaining_padock_club_count) +
                            Number(speakerData.remaining_padock_club);
                    remaining_single_day_delegate_count =
                        Number(remaining_single_day_delegate_count) +
                            Number(speakerData.remaining_single_day);
                    remaining_resolve_count =
                        Number(remaining_resolve_count) +
                            Number(speakerData.remaining_resolve);
                    remaining_asset_abu_dhabi_count =
                        Number(remaining_asset_abu_dhabi_count) +
                            Number(speakerData.remaining_asset_abu_dhabi);
                    remaining_fintech_abu_dhabi_count =
                        Number(remaining_fintech_abu_dhabi_count) +
                            Number(speakerData.remaining_fintech_abu_dhabi);
                    remaining_adsff_count =
                        Number(remaining_adsff_count) +
                            Number(speakerData.remaining_adsff);
                    let speakerObj = {
                        remaining_general_admission: remaining_general_admission_count,
                        remaining_executive: remaining_executive_count,
                        remaining_delegate: remaining_delegate_count,
                        remaining_padock_club: remaining_padock_club_count,
                        remaining_single_day: remaining_single_day_delegate_count,
                        remaining_resolve: remaining_resolve_count,
                        remaining_asset_abu_dhabi: remaining_asset_abu_dhabi_count,
                        remaining_fintech_abu_dhabi: remaining_fintech_abu_dhabi_count,
                        remaining_adsff: remaining_adsff_count,
                    };
                    // update spesker count
                    await strapi.entityService.update("api::speaker.speaker", speakerData.id, {
                        data: speakerObj,
                        transacting: trx,
                    });
                }
                if (((_r = eventoUpdatedData === null || eventoUpdatedData === void 0 ? void 0 : eventoUpdatedData.data) === null || _r === void 0 ? void 0 : _r.Status) === "OK") {
                    return new dataResponse_dto_1.DataResponseDto(dbResponse, "Ticket status updated successfully");
                }
                else {
                    return new dataResponse_dto_1.DataResponseDto(null, "Failed to  update ticket status");
                }
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async uploadSpeakerTickets(body) {
        try {
            const knex = strapi.db.connection;
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4;
                const orderData = await strapi.db.query("api::order.order").findOne({
                    where: { orderId: body.orderId, is_deleted: false },
                });
                if (!orderData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Order not found");
                }
                const speakerData = await strapi.db
                    .query("api::speaker.speaker")
                    .findOne({
                    where: { id: body.speakerId, is_deleted: false },
                });
                if (!speakerData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Speaker not found");
                }
                if (!body.ticketData || body.ticketData.length === 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please add tickets data");
                }
                const addTicket = [];
                const deleteIds = [];
                const updateTicket = [];
                let remaining_executive_count = Number(speakerData.remaining_executive) || 0;
                let remaining_delegate_count = Number(speakerData.remaining_delegate) || 0;
                let remaining_padock_club_count = Number(speakerData.remaining_padock_club) || 0;
                let remaining_general_admission_count = Number(speakerData.remaining_general_admission) || 0;
                let remaining_single_day_delegate_count = Number(speakerData.remaining_single_day) || 0;
                let remaining_resolve_count = Number(speakerData.remaining_resolve) | 0;
                let remaining_asset_abu_dhabi_count = Number(speakerData.remaining_asset_abu_dhabi) || 0;
                let remaining_fintech_abu_dhabi_count = Number(speakerData.remaining_fintech_abu_dhabi) || 0;
                let remaining_adsff_count = Number(speakerData.remaining_adsff) || 0;
                function updateRemainingCount(ticketIdShort, dayIdShort, countChange) {
                    switch (ticketIdShort) {
                        case "general_admission":
                            remaining_general_admission_count += Number(countChange);
                            break;
                        case "executive":
                            remaining_executive_count += Number(countChange);
                            break;
                        case "delegate":
                            remaining_delegate_count += Number(countChange);
                            break;
                        case "padock_club":
                            remaining_padock_club_count += Number(countChange);
                            break;
                        case "single_day_delegate":
                            remaining_single_day_delegate_count += Number(countChange);
                            switch (dayIdShort) {
                                case "resolve":
                                    remaining_resolve_count += Number(countChange);
                                    break;
                                case "asset_abu_dhabi":
                                    remaining_asset_abu_dhabi_count += Number(countChange);
                                    break;
                                case "fintech_abu_dhabi":
                                    remaining_fintech_abu_dhabi_count += Number(countChange);
                                    break;
                                case "adsff":
                                    remaining_adsff_count += Number(countChange);
                                    break;
                            }
                            break;
                    }
                }
                const createdTicketIds = [];
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.filter(item => item.status == "draft").length);
                for (const [index, ticket] of body.ticketData.filter((item) => item.status == "draft").entries()) {
                    let obj = {
                        type: body === null || body === void 0 ? void 0 : body.type,
                        first_name: ticket === null || ticket === void 0 ? void 0 : ticket.firstName,
                        last_name: ticket === null || ticket === void 0 ? void 0 : ticket.lastName,
                        email: (_a = ticket === null || ticket === void 0 ? void 0 : ticket.email) === null || _a === void 0 ? void 0 : _a.trim(),
                        day: ticket === null || ticket === void 0 ? void 0 : ticket.day,
                        order_number: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                        ticket_holder: "speaker",
                        day_short: (_b = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _b === void 0 ? void 0 : _b.id_short,
                    };
                    if (ticket.action === "add") {
                        let badgeCategory = ((_c = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.id_short) === "executive"
                            ? "Official"
                            : ((_d = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _d === void 0 ? void 0 : _d.id_short) === "delegate"
                                ? "Full Week"
                                : ((_e = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _e === void 0 ? void 0 : _e.id_short) === "general_admission"
                                    ? "Visitor"
                                    : (_f = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _f === void 0 ? void 0 : _f.event;
                        obj.status = body.isSave ? "draft" : "unassigned";
                        obj.badge_category = (ticket === null || ticket === void 0 ? void 0 : ticket.badgeCategory) || badgeCategory;
                        obj.published_at = new Date();
                        obj.created_at = new Date();
                        obj.allow_email = true;
                        obj.is_deleted = false;
                        obj.payment_status = "Free";
                        obj.allow_chat = false;
                        obj.is_sync_evento = false;
                        obj.ticket_number = ticketNumbers[index];
                        addTicket.push(obj);
                        createdTicketIds.push((_g = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _g === void 0 ? void 0 : _g.id);
                        if (!body.isSave) {
                            updateRemainingCount((_h = ticket.ticket_id) === null || _h === void 0 ? void 0 : _h.id_short, (_j = ticket.day) === null || _j === void 0 ? void 0 : _j.id_short, -1);
                        }
                    }
                    else if (ticket.action === "delete") {
                        deleteIds.push(ticket.id);
                        if (ticket.status === "unassigned") {
                            updateRemainingCount((_k = ticket.ticket_id) === null || _k === void 0 ? void 0 : _k.id_short, (_l = ticket.day) === null || _l === void 0 ? void 0 : _l.id_short, +1);
                        }
                    }
                    else {
                        obj.status =
                            ticket.status == "draft"
                                ? !(body === null || body === void 0 ? void 0 : body.isSave)
                                    ? "unassigned"
                                    : ticket.status
                                : ticket.status;
                        obj.id = ticket.id;
                        obj.ticket_number = body === null || body === void 0 ? void 0 : body.ticketNumber;
                        updateTicket.push(obj);
                        const data = await strapi.db
                            .query("api::ticket-master.ticket-master")
                            .findOne({
                            where: { id: ticket.id },
                            populate: { ticket_id: true },
                        });
                        if (((_m = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _m === void 0 ? void 0 : _m.id_short) !== ((_o = ticket.ticket_id) === null || _o === void 0 ? void 0 : _o.id_short)) {
                            if ((data === null || data === void 0 ? void 0 : data.status) == "unassigned" &&
                                obj.status == "unassigned") {
                                // reduce new ticket count
                                updateRemainingCount((_p = ticket.ticket_id) === null || _p === void 0 ? void 0 : _p.id_short, (_q = ticket.day) === null || _q === void 0 ? void 0 : _q.id_short, -1);
                                // increase existing ticket count
                                updateRemainingCount((_r = data.ticket_id) === null || _r === void 0 ? void 0 : _r.id_short, (_s = data.day) === null || _s === void 0 ? void 0 : _s.id_short, 1);
                            }
                        }
                        if ((data === null || data === void 0 ? void 0 : data.status) == "draft" && obj.status == "unassigned") {
                            if (((_t = data === null || data === void 0 ? void 0 : data.ticket_id) === null || _t === void 0 ? void 0 : _t.id_short) == "single_day_delegate" &&
                                ((_u = obj.ticket_id) === null || _u === void 0 ? void 0 : _u.id_short) == "single_day_delegate") {
                                if (((_v = data === null || data === void 0 ? void 0 : data.day) === null || _v === void 0 ? void 0 : _v.id_short) == ((_w = obj.day) === null || _w === void 0 ? void 0 : _w.id_short)) {
                                    updateRemainingCount((_x = ticket.ticket_id) === null || _x === void 0 ? void 0 : _x.id_short, (_y = ticket.day) === null || _y === void 0 ? void 0 : _y.id_short, -1);
                                }
                                else {
                                    // reduce new ticket count
                                    updateRemainingCount((_z = ticket.ticket_id) === null || _z === void 0 ? void 0 : _z.id_short, (_0 = ticket.day) === null || _0 === void 0 ? void 0 : _0.id_short, -1);
                                    // increase existing ticket count
                                    updateRemainingCount((_1 = data.ticket_id) === null || _1 === void 0 ? void 0 : _1.id_short, (_2 = data.day) === null || _2 === void 0 ? void 0 : _2.id_short, 1);
                                }
                            }
                            else {
                                updateRemainingCount((_3 = ticket.ticket_id) === null || _3 === void 0 ? void 0 : _3.id_short, (_4 = ticket.day) === null || _4 === void 0 ? void 0 : _4.id_short, -1);
                            }
                        }
                    }
                }
                if (remaining_general_admission_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for general admission tickets.");
                }
                else if (remaining_executive_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for executive tickets.");
                }
                else if (remaining_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for delegate tickets.");
                }
                else if (remaining_padock_club_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for padock club tickets");
                }
                else if (remaining_single_day_delegate_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for single day limit");
                }
                else if (remaining_resolve_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for resolve tickets.");
                }
                else if (remaining_asset_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for asset abu dhabi tickets.");
                }
                else if (remaining_fintech_abu_dhabi_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for fintech abu dhabi tickets.");
                }
                else if (remaining_adsff_count < 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Cannot generate ticket: You have exceeded the limit for adsff tickets.");
                }
                let limitObj = {
                    remaining_executive: remaining_executive_count,
                    remaining_delegate: remaining_delegate_count,
                    remaining_padock_club: remaining_padock_club_count,
                    remaining_general_admission: remaining_general_admission_count,
                    remaining_single_day: remaining_single_day_delegate_count,
                    remaining_resolve: remaining_resolve_count,
                    remaining_asset_abu_dhabi: remaining_asset_abu_dhabi_count,
                    remaining_fintech_abu_dhabi: remaining_fintech_abu_dhabi_count,
                    remaining_adsff: remaining_adsff_count,
                };
                // update remaining count
                await strapi.entityService.update("api::speaker.speaker", speakerData.id, {
                    data: limitObj,
                    transacting: trx,
                });
                const responseArray = [];
                if (addTicket.length) {
                    const createdData = await knex("ticket_masters").insert(addTicket).transacting(trx).returning("id");
                    const ticket_ticket_master_data = [];
                    const order_ticket_data = createdData.map((item, index) => {
                        ticket_ticket_master_data.push({
                            ticket_master_id: item.id,
                            ticket_id: createdTicketIds[index],
                            ticket_master_order: Number(index) + 1
                        });
                        return {
                            ticket_master_id: item.id,
                            order_id: orderData.id,
                            ticket_master_order: Number(index) + 1
                        };
                    });
                    // 4. create entries to ticket_masters_order_id_links table
                    await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                    // 5. create entries to ticket_masters_ticket_id_links table
                    await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                    responseArray.push({
                        createdEntriesCount: createdData,
                        addReqCount: addTicket === null || addTicket === void 0 ? void 0 : addTicket.length
                    });
                }
                if (deleteIds.length) {
                    const deletedData = await knex("ticket_masters").whereIn("id", deleteIds).del().transacting(trx);
                    responseArray.push({
                        deletedEntriesCount: deletedData,
                        deletedReqCount: deleteIds.length,
                    });
                }
                if (updateTicket.length) {
                    const updatedArray = [];
                    let updateSuccessCount = 0;
                    let updateFailedCount = 0;
                    await Promise.all(updateTicket.map(async (item) => {
                        if (item === null || item === void 0 ? void 0 : item.id) {
                            await knex("ticket_masters")
                                .where("id", item.id)
                                .update(item)
                                .transacting(trx)
                                .returning('id');
                            updateSuccessCount++;
                            updatedArray.push({
                                updateStatus: true,
                                message: "success",
                                id: item === null || item === void 0 ? void 0 : item.id,
                            });
                        }
                        else {
                            updateFailedCount++;
                            updatedArray.push({
                                updateStatus: false,
                                message: "provide id for updating data",
                                data: item,
                            });
                        }
                    }));
                    responseArray.push({
                        updatedEntries: updateSuccessCount,
                        failedEntries: updateFailedCount,
                        updateReqCount: updateTicket.length,
                        data: updatedArray,
                    });
                }
                return new dataResponse_dto_1.DataResponseDto(responseArray, "Speaker tickets uploaded successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async uploadUBSTickets(body) {
        try {
            const knex = strapi.db.connection;
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c;
                if (!body.ticketData || body.ticketData.length === 0) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Please add tickets data");
                }
                const orderData = await strapi.db.query("api::order.order").findOne({
                    where: { orderId: body.orderId, is_deleted: false },
                });
                if (!orderData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Order not found");
                }
                const sponsorData = await strapi.db
                    .query("api::sponsor.sponsor")
                    .findOne({
                    where: { sponsor_id: body.sponsorId, is_deleted: false },
                });
                if (!sponsorData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Sponsor not found");
                }
                ;
                const createdTicketIds = [];
                const addTicket = [];
                const deleteIds = [];
                const updateTicket = [];
                const ticketNumbers = await (0, generateTicketNumbers_1.generateTicketNumbersForUpload)("I", body === null || body === void 0 ? void 0 : body.ticketData.filter(item => item.status == "draft").length);
                for (const [index, ticket] of body.ticketData.filter((item) => item.status == "draft").entries()) {
                    let obj = {
                        type: body === null || body === void 0 ? void 0 : body.type,
                        first_name: ticket === null || ticket === void 0 ? void 0 : ticket.firstName,
                        last_name: ticket === null || ticket === void 0 ? void 0 : ticket.lastName,
                        email: (_a = ticket === null || ticket === void 0 ? void 0 : ticket.email) === null || _a === void 0 ? void 0 : _a.trim(),
                        day: ticket === null || ticket === void 0 ? void 0 : ticket.day,
                        order_number: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                        day_short: (_b = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _b === void 0 ? void 0 : _b.id_short,
                        company: ticket === null || ticket === void 0 ? void 0 : ticket.company,
                        sector: ticket === null || ticket === void 0 ? void 0 : ticket.sector,
                        designation: ticket === null || ticket === void 0 ? void 0 : ticket.designation,
                        nationality: ticket === null || ticket === void 0 ? void 0 : ticket.nationality,
                        residance_country: ticket === null || ticket === void 0 ? void 0 : ticket.residanceCountry,
                        country_code: ticket === null || ticket === void 0 ? void 0 : ticket.countryCode,
                        mobile: ticket === null || ticket === void 0 ? void 0 : ticket.mobile,
                        photo: (ticket === null || ticket === void 0 ? void 0 : ticket.photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        emirate: ticket === null || ticket === void 0 ? void 0 : ticket.emirate,
                        badge_category: ticket === null || ticket === void 0 ? void 0 : ticket.badgeCategory,
                        sub_sector: ticket === null || ticket === void 0 ? void 0 : ticket.subSector
                    };
                    if (ticket.action === "add") {
                        obj.status = body.isSave ? "draft" : "assigned";
                        obj.badge_category = (ticket === null || ticket === void 0 ? void 0 : ticket.badgeCategory) || "Partner";
                        obj.ticket_holder = (ticket === null || ticket === void 0 ? void 0 : ticket.ticketHolder) || "sponsor";
                        obj.published_at = new Date();
                        obj.created_at = new Date();
                        obj.payment_status = "Free";
                        obj.allow_email = false;
                        obj.is_deleted = false;
                        obj.ticket_number = ticketNumbers[index];
                        obj.is_ubs_sponsor = true;
                        obj.allow_chat = false;
                        obj.is_sync_evento = false;
                        addTicket.push(obj);
                        createdTicketIds.push((_c = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _c === void 0 ? void 0 : _c.id);
                    }
                    else if (ticket.action === "delete") {
                        deleteIds.push(ticket.id);
                    }
                    else {
                        obj.status =
                            ticket.status == "draft"
                                ? !(body === null || body === void 0 ? void 0 : body.isSave)
                                    ? "assigned"
                                    : ticket.status
                                : ticket.status;
                        obj.id = ticket.id;
                        updateTicket.push(obj);
                    }
                }
                ;
                const responseArray = [];
                if (addTicket.length) {
                    const createdData = await knex("ticket_masters").insert(addTicket).transacting(trx).returning("id");
                    // find the laster order from ticket_masters_sponsor_links table
                    const ticket_masters_sponsor_link_order = await strapi.db.connection('ticket_masters_sponsor_links')
                        .where({ sponsor_id: sponsorData === null || sponsorData === void 0 ? void 0 : sponsorData.id })
                        .orderBy('id', 'desc')
                        .first();
                    let last_ticket_master_order = 0;
                    if (ticket_masters_sponsor_link_order) {
                        last_ticket_master_order = Number(ticket_masters_sponsor_link_order.ticket_master_order);
                    }
                    const ticket_ticket_master_data = [];
                    const sponsor_ticket_link_data = [];
                    const order_ticket_data = createdData.map((item, index) => {
                        ticket_ticket_master_data.push({
                            ticket_master_id: item.id,
                            ticket_id: createdTicketIds[index],
                            ticket_master_order: Number(index) + 1
                        });
                        sponsor_ticket_link_data.push({
                            ticket_master_id: item.id,
                            sponsor_id: sponsorData.id,
                            ticket_master_order: Number(last_ticket_master_order) + index + 1
                        });
                        return {
                            ticket_master_id: item.id,
                            order_id: orderData.id,
                            ticket_master_order: Number(index) + 1
                        };
                    });
                    // 4. create entries to ticket_masters_order_id_links table
                    await knex("ticket_masters_order_id_links").insert(order_ticket_data).transacting(trx);
                    // 5. create entries to ticket_masters_ticket_id_links table
                    await knex("ticket_masters_ticket_id_links").insert(ticket_ticket_master_data).transacting(trx);
                    // 6. create entries to ticket_masters_sponsor_links table
                    await knex("ticket_masters_sponsor_links").insert(sponsor_ticket_link_data).transacting(trx);
                    responseArray.push({
                        createdEntriesCount: createdData,
                        addReqCount: addTicket === null || addTicket === void 0 ? void 0 : addTicket.length
                    });
                }
                if (deleteIds.length) {
                    const deletedData = await knex("ticket_masters").whereIn("id", deleteIds).del().transacting(trx);
                    responseArray.push({
                        deletedEntriesCount: deletedData,
                        deletedReqCount: deleteIds.length,
                    });
                }
                if (updateTicket.length) {
                    const updatedArray = [];
                    let updateSuccessCount = 0;
                    let updateFailedCount = 0;
                    await Promise.all(updateTicket.map(async (item) => {
                        if (item === null || item === void 0 ? void 0 : item.id) {
                            await knex("ticket_masters")
                                .where("id", item.id)
                                .update(item)
                                .transacting(trx)
                                .returning('id');
                            updateSuccessCount++;
                            updatedArray.push({
                                updateStatus: true,
                                message: "success",
                                id: item === null || item === void 0 ? void 0 : item.id,
                            });
                        }
                        else {
                            updateFailedCount++;
                            updatedArray.push({
                                updateStatus: false,
                                message: "provide id for updating data",
                                data: item,
                            });
                        }
                    }));
                    responseArray.push({
                        updatedEntries: updateSuccessCount,
                        failedEntries: updateFailedCount,
                        updateReqCount: updateTicket.length,
                        data: updatedArray,
                    });
                }
                return new dataResponse_dto_1.DataResponseDto(responseArray, "UBS tickets uploaded sucessfully");
            });
            return result;
        }
        catch (error) {
            console.log("error in upload the ubs tickets ", error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateBadgeCategoryByTicketNumber(ticketNumber, body) {
        var _a, _b;
        try {
            const existingData = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: { ticketNumber: ticketNumber, is_deleted: false,
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted", "draft",
                        ],
                    }
                },
                populate: { ticket_id: true },
            });
            if (!existingData) {
                return new dataResponse_dto_1.DataResponseDto(null, "Ticket not found");
            }
            const updatedRecord = await strapi.db
                .query("api::ticket-master.ticket-master")
                .update({
                where: { ticketNumber: ticketNumber, is_deleted: false },
                data: { badgeCategory: body.badgeCategory },
            });
            let externalRegister;
            if (existingData.status === "issued") {
                let payment = existingData.paymentStatus === "Free" ? "Foc" : "Paid";
                let URL = process.env.EVENTO_VISITOR_INSERT;
                let reqObj = {
                    BadgeCategory: body.badgeCategory || existingData.badgeCategory,
                    OrderNumber: existingData.orderNumber,
                    VisitorNumber: existingData.ticketNumber,
                    FirstName: existingData.firstName,
                    LastName: existingData.lastName,
                    Email: existingData.email,
                    Company: existingData.company,
                    Sector: existingData.sector,
                    JobTitle: existingData.designation,
                    Nationality: existingData.nationality,
                    Country: existingData.residanceCountry,
                    Emirate: existingData.emirate || "",
                    Photo: existingData.photo,
                    Mobile: (existingData === null || existingData === void 0 ? void 0 : existingData.countryCode) &&
                        (existingData === null || existingData === void 0 ? void 0 : existingData.mobile) &&
                        `${existingData.countryCode.replace("+", "")} ${existingData.mobile}`,
                    City: existingData.nationality,
                    Quantiy: 1,
                    Payment: payment,
                    SingleDay: (_a = existingData.day) === null || _a === void 0 ? void 0 : _a.event,
                    TicketType: (_b = existingData.ticket_id) === null || _b === void 0 ? void 0 : _b.id_short,
                };
                externalRegister = await axios.post(URL, reqObj, {
                    headers: {
                        Authorization: process.env.EVENTO_VISITOR_TOKEN,
                        "Content-Type": "application/json",
                    },
                });
            }
            return new dataResponse_dto_1.DataResponseDto({ updatedRecord, eventoData: externalRegister === null || externalRegister === void 0 ? void 0 : externalRegister.data }, "Ticket badge category  updated successfully");
        }
        catch (error) {
            console.log("error in updating the badge category ", error);
            return new dataResponse_dto_1.DataResponseDto(null, "error in updating the badge category");
        }
    },
    async createPrivateEventTicket(body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a;
                let generatedOrderNumber = await generateOrderNum("other");
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: generatedOrderNumber,
                        type: "myself",
                        paymentId: null,
                        eventDate: new Date(),
                        firstName: body === null || body === void 0 ? void 0 : body.firstName,
                        lastName: body === null || body === void 0 ? void 0 : body.lastName,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        sector: body === null || body === void 0 ? void 0 : body.sector,
                        designation: body === null || body === void 0 ? void 0 : body.designation,
                        nationality: body === null || body === void 0 ? void 0 : body.nationality,
                        residanceCountry: body === null || body === void 0 ? void 0 : body.residanceCountry,
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        mobile: body === null || body === void 0 ? void 0 : body.mobile,
                        photo: (body === null || body === void 0 ? void 0 : body.photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        ticketCount: 1,
                        discountAmount: 0,
                        totalAmount: 0,
                        paidAmount: 0,
                        is_discounted: false,
                        publishedAt: new Date(),
                        emirate: body === null || body === void 0 ? void 0 : body.emirate,
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Free",
                        userType: "private-event",
                        privateAgenda: body === null || body === void 0 ? void 0 : body.privateAgendaId
                    },
                    // transacting: trx,
                });
                let tiket_number = await generateTicketNum("I");
                // fetch executive ticket
                const ticketType = await strapi.db.query("api::ticket.ticket").findOne({
                    where: { id_short: "executive", is_deleted: false }
                });
                let ticket = {
                    ticket_id: ticketType === null || ticketType === void 0 ? void 0 : ticketType.id,
                    type: "myself",
                    firstName: body === null || body === void 0 ? void 0 : body.firstName,
                    lastName: body === null || body === void 0 ? void 0 : body.lastName,
                    email: body === null || body === void 0 ? void 0 : body.email,
                    day: {
                        id: "other",
                        date: "",
                        event: "Other",
                        value: "Other"
                    },
                    orderId: order === null || order === void 0 ? void 0 : order.id,
                    ticketNumber: tiket_number,
                    company: body === null || body === void 0 ? void 0 : body.company,
                    sector: body === null || body === void 0 ? void 0 : body.sector,
                    designation: body === null || body === void 0 ? void 0 : body.designation,
                    nationality: body === null || body === void 0 ? void 0 : body.nationality,
                    residanceCountry: body === null || body === void 0 ? void 0 : body.residanceCountry,
                    countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                    mobile: body === null || body === void 0 ? void 0 : body.mobile,
                    photo: body === null || body === void 0 ? void 0 : body.photo,
                    orderNumber: generatedOrderNumber,
                    publishedAt: new Date(),
                    emirate: body === null || body === void 0 ? void 0 : body.emirate,
                    utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                    utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                    utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                    utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                    utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                    badgeCategory: "Official",
                    paymentStatus: "Free",
                    status: "assigned",
                    ticketHolder: "private-event",
                    subSector: body === null || body === void 0 ? void 0 : body.subSector,
                    dayShort: ((_a = body === null || body === void 0 ? void 0 : body.day) === null || _a === void 0 ? void 0 : _a.id_short) || "",
                    allowEmail: body === null || body === void 0 ? void 0 : body.allowEmail
                };
                const ticketMaster = await strapi.entityService.create("api::ticket-master.ticket-master", {
                    data: ticket,
                    populate: {
                        ticket_id: true,
                    },
                    transacting: trx,
                });
                return new dataResponse_dto_1.DataResponseDto(ticketMaster, "Private event ticket created successfuly");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async approvePrivateEventTicket(ticketId, userId) {
        var _a, _b, _c, _d, _e, _f, _g;
        try {
            const ticketData = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: { id: ticketId, is_deleted: false,
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"]
                    }
                },
                populate: true,
            });
            if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.status) === "issued") {
                return new dataResponse_dto_1.DataResponseDto(null, "This ticket has already been issued");
            }
            const updateTicket = await strapi.db.query("api::ticket-master.ticket-master").update({
                where: { id: ticketId, is_deleted: false },
                data: { status: "issued", modifiedBy: userId },
                populate: {
                    ticket_id: true,
                },
            });
            if (ticketData === null || ticketData === void 0 ? void 0 : ticketData.allowEmail) {
                // send email to the ticket holder
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                let obj = {
                    key: process.env.MANDRILL_KEY,
                    template_name: process.env.ISSUE_TICKET_TEMPLATE_NAME,
                    template_content: [],
                    message: {
                        to: [
                            {
                                email: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.email,
                                name: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.firstName,
                                type: "to",
                            },
                        ],
                        from_email: "donotreply@adfw.com",
                        from_name: "Abu Dhabi Finance Week",
                        global_merge_vars: [
                            {
                                name: "FIRSTNAME",
                                content: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.firstName,
                            },
                            {
                                name: "FULLNAME",
                                content: `${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.firstName} ${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.lastName}`,
                            },
                            {
                                name: "EMAIL",
                                content: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.email,
                            },
                            {
                                name: "TICKETTYPE",
                                content: ((_b = (_a = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.day) === null || _a === void 0 ? void 0 : _a.event) === null || _b === void 0 ? void 0 : _b.toLowerCase()) === "other"
                                    ? updateTicket.ticket_id.title
                                    : `${(_c = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticket_id) === null || _c === void 0 ? void 0 : _c.title}: ${(_d = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.day) === null || _d === void 0 ? void 0 : _d.event}`
                            },
                            {
                                name: "TICKETID",
                                content: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticketNumber,
                            },
                            {
                                name: "ORDERID",
                                content: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.orderNumber,
                            },
                            {
                                name: "DOWNLOADTICKET",
                                content: `${process.env.WEB_URL}ticket-download?ticketNumber=${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticketNumber}`,
                            },
                            {
                                name: "APPLEWALLET",
                                content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticketNumber}`,
                            },
                            {
                                name: "GOOGLEWALLET",
                                content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticketNumber}`
                            },
                        ],
                    },
                };
                await axios.post(mandrilURL, obj);
            }
            // insert entry to evento 
            let URL = process.env.EVENTO_VISITOR_INSERT;
            let reqObj = {
                OrderNumber: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.orderNumber) || "",
                VisitorNumber: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticketNumber) || "",
                FirstName: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.firstName) || "",
                LastName: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.lastName) || "",
                Company: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.company) || "",
                JobTitle: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.designation) || "",
                Email: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.email) || "",
                Nationality: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.nationality) || "",
                BadgeCategory: updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.badgeCategory,
                Country: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.residanceCountry) || "",
                Mobile: `${(_e = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.countryCode) === null || _e === void 0 ? void 0 : _e.replace("+", "")} ${updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.mobile} ` || "",
                SingleDay: ((_f = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.day) === null || _f === void 0 ? void 0 : _f.event) || "Other",
                TicketType: ((_g = updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.ticket_id) === null || _g === void 0 ? void 0 : _g.id_short) || "",
                Sector: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.sector) || "Other",
                City: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.nationality) || "",
                Payment: "Foc",
                Emirate: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.emirate) || "",
                Photo: (updateTicket === null || updateTicket === void 0 ? void 0 : updateTicket.photo) || "",
                Quantiy: 1,
            };
            await axios.post(URL, reqObj, {
                headers: {
                    Authorization: process.env.EVENTO_VISITOR_TOKEN,
                    "Content-Type": "application/json",
                },
            });
            return new dataResponse_dto_1.DataResponseDto(updateTicket, "Ticket approved successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async createUnsyncOrder(orderId, params) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b;
                const { discountId, discountAmount, isDiscounted } = params;
                const logData = await strapi
                    .query("api::payment-log.payment-log")
                    .findOne({
                    where: { orderId: orderId, status: "pending" },
                });
                if (!logData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "No data found in log table");
                }
                ;
                const reqObj = logData === null || logData === void 0 ? void 0 : logData.requestData;
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: reqObj === null || reqObj === void 0 ? void 0 : reqObj.OrderNumber,
                        type: reqObj === null || reqObj === void 0 ? void 0 : reqObj.type,
                        eventDate: new Date(),
                        firstName: reqObj === null || reqObj === void 0 ? void 0 : reqObj.FirstName,
                        lastName: reqObj === null || reqObj === void 0 ? void 0 : reqObj.LastName,
                        email: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Email,
                        company: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Company,
                        sector: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Sector,
                        designation: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Designation,
                        nationality: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Nationality,
                        residanceCountry: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Country,
                        countryCode: reqObj === null || reqObj === void 0 ? void 0 : reqObj.countryCode,
                        mobile: reqObj === null || reqObj === void 0 ? void 0 : reqObj.phone,
                        photo: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.Photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        ticketCount: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Quantity,
                        discountAmount: Number(discountAmount) || 0,
                        totalAmount: reqObj === null || reqObj === void 0 ? void 0 : reqObj.totalPrice,
                        paidAmount: reqObj === null || reqObj === void 0 ? void 0 : reqObj.totalPrice,
                        is_discounted: isDiscounted || false,
                        publishedAt: new Date(),
                        emirate: reqObj === null || reqObj === void 0 ? void 0 : reqObj.emirate,
                        utm_medium: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_medium) || "",
                        utm_source: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_source) || "",
                        utm_campaign: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_campaign) || "",
                        utm_content: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_content) || "",
                        utm_id: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_id) || "",
                        status: "Paid",
                        userType: "regular"
                    },
                    transacting: trx,
                });
                let ticketMasters = [];
                const ticketCount = reqObj.Quantity || 1;
                for (let i = 0; i < ticketCount; i++) {
                    let tiket_number = await generateTicketNum("B");
                    const badgeCategory = (reqObj === null || reqObj === void 0 ? void 0 : reqObj.TicketType) === "executive"
                        ? "Official"
                        : (reqObj === null || reqObj === void 0 ? void 0 : reqObj.TicketType) === "delegate"
                            ? "Full Week"
                            : (reqObj === null || reqObj === void 0 ? void 0 : reqObj.TicketType) === "general_admission"
                                ? "Visitor"
                                : (_a = reqObj === null || reqObj === void 0 ? void 0 : reqObj.day) === null || _a === void 0 ? void 0 : _a.event;
                    let ticket = {
                        ticket_id: reqObj.ticketId,
                        type: reqObj.type,
                        firstName: reqObj === null || reqObj === void 0 ? void 0 : reqObj.FirstName,
                        lastName: reqObj === null || reqObj === void 0 ? void 0 : reqObj.LastName,
                        email: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Email,
                        day: reqObj === null || reqObj === void 0 ? void 0 : reqObj.day,
                        orderId: order === null || order === void 0 ? void 0 : order.id,
                        ticketNumber: tiket_number,
                        company: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Company,
                        sector: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Sector,
                        designation: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Designation,
                        nationality: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Nationality,
                        residanceCountry: reqObj === null || reqObj === void 0 ? void 0 : reqObj.Country,
                        countryCode: reqObj === null || reqObj === void 0 ? void 0 : reqObj.countryCode,
                        mobile: reqObj === null || reqObj === void 0 ? void 0 : reqObj.phone,
                        photo: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.Photo) || constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                        orderNumber: reqObj === null || reqObj === void 0 ? void 0 : reqObj.OrderNumber,
                        publishedAt: new Date(),
                        emirate: reqObj === null || reqObj === void 0 ? void 0 : reqObj.emirate,
                        utm_source: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_source) || "",
                        utm_medium: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_medium) || "",
                        utm_campaign: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_campaign) || "",
                        utm_content: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_content) || "",
                        utm_id: (reqObj === null || reqObj === void 0 ? void 0 : reqObj.utm_id) || "",
                        token: "",
                        badgeCategory: badgeCategory,
                        paymentStatus: "Paid",
                        dayShort: (_b = reqObj === null || reqObj === void 0 ? void 0 : reqObj.day) === null || _b === void 0 ? void 0 : _b.id_short,
                    };
                    if (reqObj.type === "myself") {
                        ticket["status"] = "issued";
                    }
                    else {
                        ticket["status"] = "unassigned";
                    }
                    const ticketMaster = await strapi.entityService.create("api::ticket-master.ticket-master", {
                        data: ticket,
                        populate: {
                            ticket_id: true,
                        },
                        transacting: trx,
                    });
                    ticketMasters.push(ticketMaster);
                }
                if (discountId) {
                    await strapi
                        .service("api::discount-code.discount-code")
                        .updateDiscountCodeCount(discountId);
                }
                // update log
                await strapi.db.query("api::payment-log.payment-log").update({
                    where: {
                        orderId: orderId,
                    },
                    data: {
                        status: "succeeded",
                        details: { order, ticketMasters },
                    },
                });
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async resendEmail(params) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
        try {
            const { ticketNumber, orderNumber } = params;
            if (!ticketNumber && !orderNumber) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide valid data");
            }
            if (ticketNumber) {
                const ticketData = await strapi.db.query("api::ticket-master.ticket-master").findOne({
                    where: { ticketNumber, is_deleted: false,
                        status: {
                            $notIn: [
                                "refunded", "cancelled", "deleted", "draft",
                            ],
                        }
                    },
                    populate: {
                        orderId: true,
                        ticket_id: true
                    }
                });
                if (!ticketData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Ticket not found");
                }
                if ((ticketData === null || ticketData === void 0 ? void 0 : ticketData.status) !== "issued") {
                    return new dataResponse_dto_1.DataResponseDto(null, "This ticket is not issued");
                }
                if (!(ticketData === null || ticketData === void 0 ? void 0 : ticketData.allowEmail)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Sending email to this ticket holder is disabled");
                }
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                let obj = {
                    key: process.env.MANDRILL_KEY,
                    template_name: process.env.ISSUE_TICKET_TEMPLATE_NAME,
                    template_content: [],
                    message: {
                        to: [
                            {
                                email: ticketData === null || ticketData === void 0 ? void 0 : ticketData.email,
                                name: ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName,
                                type: "to",
                            },
                        ],
                        from_email: "donotreply@adfw.com",
                        from_name: "Abu Dhabi Finance Week",
                        global_merge_vars: [
                            {
                                name: "FIRSTNAME",
                                content: ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName,
                            },
                            {
                                name: "FULLNAME",
                                content: `${ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName} ${ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName}`,
                            },
                            {
                                name: "EMAIL",
                                content: ticketData === null || ticketData === void 0 ? void 0 : ticketData.email,
                            },
                            {
                                name: "TICKETTYPE",
                                content: ((_b = (_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _a === void 0 ? void 0 : _a.event) === null || _b === void 0 ? void 0 : _b.toLowerCase()) === "other"
                                    ? ticketData.ticket_id.title
                                    : `${(_c = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _c === void 0 ? void 0 : _c.title}: ${(_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _d === void 0 ? void 0 : _d.event}`,
                            },
                            {
                                name: "TICKETID",
                                content: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
                            },
                            {
                                name: "ORDERID",
                                content: ticketData === null || ticketData === void 0 ? void 0 : ticketData.orderNumber,
                            },
                            {
                                name: "DOWNLOADTICKET",
                                content: `${process.env.WEB_URL}ticket-download?ticketNumber=${ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber}`,
                            },
                            {
                                name: "APPLEWALLET",
                                content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber}`,
                            },
                            {
                                name: "GOOGLEWALLET",
                                content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber}`
                            },
                        ],
                    },
                };
                await axios.post(mandrilURL, obj);
                return new dataResponse_dto_1.DataResponseDto(ticketData, "Email sent successfully");
            }
            if (orderNumber) {
                const orderData = await strapi.db.query("api::order.order").findOne({
                    where: {
                        orderId: orderNumber,
                        is_deleted: false
                    },
                    populate: {
                        ticket_masters: {
                            populate: {
                                ticket_id: true
                            }
                        }
                    }
                });
                if (!orderData) {
                    return new dataResponse_dto_1.DataResponseDto(null, "No order found");
                }
                if (orderData.userType === "regular" && orderData.status === "Paid") {
                    const secret = process.env.EVENTO_JWT_SECRET;
                    const jwtPayload = {
                        identifier: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                        Status: "paid"
                    };
                    const token = jwt.sign(jwtPayload, secret);
                    let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                    let obj = {
                        key: process.env.MANDRILL_KEY,
                        template_name: process.env.BUY_FOR_OTHERS_TEMPLATE_NAME,
                        template_content: [],
                        message: {
                            to: [
                                {
                                    email: orderData === null || orderData === void 0 ? void 0 : orderData.email,
                                    name: orderData === null || orderData === void 0 ? void 0 : orderData.firstName,
                                    type: "to",
                                },
                            ],
                            from_email: "donotreply@adfw.com",
                            from_name: "Abu Dhabi Finance Week",
                            global_merge_vars: [
                                {
                                    name: "FIRSTNAME",
                                    content: orderData === null || orderData === void 0 ? void 0 : orderData.firstName,
                                },
                                {
                                    name: "TICKETCOUNT",
                                    content: orderData === null || orderData === void 0 ? void 0 : orderData.ticketCount,
                                },
                                {
                                    name: "TICKETTYPE",
                                    content: ((_g = (_f = (_e = orderData === null || orderData === void 0 ? void 0 : orderData.ticket_masters[0]) === null || _e === void 0 ? void 0 : _e.day) === null || _f === void 0 ? void 0 : _f.event) === null || _g === void 0 ? void 0 : _g.toLowerCase()) !== "other"
                                        ? `${(_j = (_h = orderData === null || orderData === void 0 ? void 0 : orderData.ticket_masters[0]) === null || _h === void 0 ? void 0 : _h.ticket_id) === null || _j === void 0 ? void 0 : _j.title}: ${(_l = (_k = orderData === null || orderData === void 0 ? void 0 : orderData.ticket_masters[0]) === null || _k === void 0 ? void 0 : _k.day) === null || _l === void 0 ? void 0 : _l.event}`
                                        : (_o = (_m = orderData === null || orderData === void 0 ? void 0 : orderData.ticket_masters[0]) === null || _m === void 0 ? void 0 : _m.ticket_id) === null || _o === void 0 ? void 0 : _o.title,
                                },
                                {
                                    name: "FULLNAME",
                                    content: `${orderData === null || orderData === void 0 ? void 0 : orderData.firstName} ${orderData === null || orderData === void 0 ? void 0 : orderData.lastName}`,
                                },
                                {
                                    name: "EMAIL",
                                    content: orderData === null || orderData === void 0 ? void 0 : orderData.email,
                                },
                                {
                                    name: "MANAGETICKET",
                                    content: `${process.env.WEB_URL}ticketing?jwt=${token}`,
                                },
                                {
                                    name: "ORDERID",
                                    content: orderData === null || orderData === void 0 ? void 0 : orderData.orderId,
                                },
                                {
                                    name: "HIDEREFUNDS",
                                    content: Number(orderData === null || orderData === void 0 ? void 0 : orderData.paidAmount) == 0 ? true : null,
                                },
                            ],
                        },
                    };
                    await axios.post(mandrilURL, obj);
                    return new dataResponse_dto_1.DataResponseDto(orderData, "Email sent successfully");
                }
                else {
                    return new dataResponse_dto_1.DataResponseDto(null, "This is a free order");
                }
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findDuplicateTicketsById(id) {
        try {
            const existingData = await strapi.db.query('api::ticket-master.ticket-master').findOne({
                where: {
                    id,
                    is_deleted: false,
                    status: {
                        $notIn: ['refunded', 'cancelled', 'deleted', 'draft']
                    }
                }
            });
            if (!existingData) {
                return new dataResponse_dto_1.DataResponseDto(null, "No ticket found");
            }
            const data = await strapi.db.query('api::ticket-master.ticket-master').findMany({
                where: {
                    email: existingData.email,
                    is_deleted: false,
                    status: {
                        $notIn: ['refunded', 'cancelled', 'deleted', 'draft']
                    }
                },
                populate: {
                    ticket_id: {
                        select: ["title"]
                    }
                },
                select: ["id", "ticketNumber", "status", "firstName", "lastName", "ticketHolder", "badgeCategory", "dayShort", "day"]
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Data fetched successfully");
        }
        catch (error) {
            console.log("error==>", error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async checkDuplicateTickets(body) {
        var _a;
        try {
            if (!(body === null || body === void 0 ? void 0 : body.emailData) || ((_a = body === null || body === void 0 ? void 0 : body.emailData) === null || _a === void 0 ? void 0 : _a.length) <= 0) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide email data");
            }
            ;
            const query = `
        WITH DuplicateTickets AS (
          SELECT
            tm.id,
            tm.ticket_number,
            tm.status,
            tm.first_name,
            tm.last_name,
            LOWER(tm.email) AS email,
            tm.badge_category,
            tm.day_short,
            t.title as ticket_title,
            t.id_short as ticket_id_short,
            COUNT(*) OVER (PARTITION BY LOWER(tm.email)) as duplicate_count
          FROM ticket_masters tm
          LEFT JOIN ticket_masters_ticket_id_links tmtl ON tm.id = tmtl.ticket_master_id
          LEFT JOIN tickets t ON tmtl.ticket_id = t.id
          WHERE 
            tm.is_deleted = false
            AND tm.status NOT IN ('draft', 'refunded', 'cancelled', 'deleted')
            AND LOWER(tm.email) IN (${body.emailData.map(() => '?').join(', ')})
        )
        SELECT
          id,
          ticket_number,
          status,
          email,
          first_name,
          last_name,
          badge_category,
          day_short,
          ticket_title,
          ticket_id_short
        FROM DuplicateTickets
        WHERE  duplicate_count > 0
        ORDER BY email;
        `;
            const params = [...body.emailData.map(item => item.email.toLowerCase())];
            const data = await strapi.db.connection.raw(query, params);
            const results = body.emailData.map(item => {
                const emailDuplicates = data.rows.filter(d => { var _a, _b; return ((_a = d === null || d === void 0 ? void 0 : d.email) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === ((_b = item === null || item === void 0 ? void 0 : item.email) === null || _b === void 0 ? void 0 : _b.toLowerCase()); });
                return {
                    email: item === null || item === void 0 ? void 0 : item.email,
                    hasDuplicates: (item === null || item === void 0 ? void 0 : item.status) === "draft" ? emailDuplicates.length > 0 : emailDuplicates.length > 1,
                    duplicateTickets: emailDuplicates.map(ticket => ({
                        id: ticket.id,
                        firstName: ticket === null || ticket === void 0 ? void 0 : ticket.first_name,
                        lastName: ticket === null || ticket === void 0 ? void 0 : ticket.last_name,
                        email: ticket === null || ticket === void 0 ? void 0 : ticket.email,
                        number: ticket.ticket_number,
                        status: ticket.status,
                        badgeCategory: ticket.badge_category,
                        dayShort: ticket === null || ticket === void 0 ? void 0 : ticket.day_short,
                        ticketTitle: ticket.ticket_title,
                        id_short: ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id_short
                    }))
                };
            });
            return new dataResponse_dto_1.DataResponseDto(results, "Data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async onsiteRegistration(body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                let dayShort = "other";
                let tiketTypeData;
                let day = {
                    id: "other",
                    event: "Other",
                    value: "Other"
                };
                if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.VISITOR) {
                    // ticket
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "general_admission", is_deleted: false },
                    });
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ASSET_ABU_DHABI) {
                    // day
                    dayShort = "asset_abu_dhabi";
                    // ticket type
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "single_day_delegate", is_deleted: false },
                    });
                    // asset abu dhabi
                    day = tiketTypeData.days.find((item) => (item === null || item === void 0 ? void 0 : item.id_short) === dayShort);
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.RESOLVE) {
                    dayShort = "resolve";
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "single_day_delegate", is_deleted: false },
                    });
                    // resolve
                    day = tiketTypeData.days.find((item) => (item === null || item === void 0 ? void 0 : item.id_short) === dayShort);
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.FINTECH_ABU_DHABI) {
                    dayShort = "fintech_abu_dhabi";
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "single_day_delegate", is_deleted: false },
                    });
                    // fintech abu dhabi
                    day = tiketTypeData.days.find((item) => (item === null || item === void 0 ? void 0 : item.id_short) === dayShort);
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ADSFF) {
                    dayShort = "adsff";
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "single_day_delegate", is_deleted: false },
                    });
                    // adsff
                    day = tiketTypeData.days.find((item) => (item === null || item === void 0 ? void 0 : item.id_short) === dayShort);
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.SPEAKER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.PARTNER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.GUEST ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ADGM_EXECUTIVE ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.OFFICIAL) {
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "executive", is_deleted: false },
                    });
                }
                else if ((body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.FULL_WEEK ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ADGM_ORGANISER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ADGM_PROTOCOL ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ADGM ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.STARTUP ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.MEDIA ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ORGANISER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.PHOTOGRAPHER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.VIDEOGRAPHER ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.CREW ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.ENTERTAIMENT_ARTIST ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.PROTOCOL ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.SECURITY ||
                    (body === null || body === void 0 ? void 0 : body.badgeCategory) === onsiteDataTypes_1.BadgeCategory.SUPPORT_STAFF) {
                    tiketTypeData = await strapi.db
                        .query("api::ticket.ticket")
                        .findOne({
                        where: { id_short: "delegate", is_deleted: false },
                    });
                }
                let existingTicket = await strapi.db
                    .query("api::ticket-master.ticket-master")
                    .findOne({
                    where: {
                        ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber,
                        is_deleted: false,
                        status: {
                            $notIn: ["refunded", "cancelled", "deleted", "draft"],
                        },
                    },
                });
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(body === null || body === void 0 ? void 0 : body.email)) {
                    return new dataResponse_dto_1.DataResponseDto(null, 'Invalid email format');
                }
                // Check if the order already exists
                let order;
                if (existingTicket) {
                    order = await strapi.db
                        .query("api::order.order")
                        .findOne({
                        where: {
                            orderId: existingTicket === null || existingTicket === void 0 ? void 0 : existingTicket.orderNumber,
                            is_deleted: false,
                            status: {
                                $notIn: ["Refunded", "Cancelled", "Deleted"]
                            }
                        },
                    });
                }
                if (order) {
                    // Update the existing order if it exists
                    order = await strapi.entityService.update("api::order.order", order.id, {
                        data: {
                            firstName: body === null || body === void 0 ? void 0 : body.firstName,
                            lastName: body === null || body === void 0 ? void 0 : body.lastName,
                            email: body === null || body === void 0 ? void 0 : body.email,
                            company: body === null || body === void 0 ? void 0 : body.company,
                            sector: (body === null || body === void 0 ? void 0 : body.industry) || "-",
                            designation: body === null || body === void 0 ? void 0 : body.designation,
                            nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "-",
                            residanceCountry: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "-",
                            countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                            mobile: (body === null || body === void 0 ? void 0 : body.phone) || "-",
                            photo: body === null || body === void 0 ? void 0 : body.photo,
                            emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "-",
                        },
                        transacting: trx,
                    });
                }
                else {
                    // Generate order and ticket numbers
                    let order_number = await generateOrderNum("myself");
                    // Create a new order if it doesn't exist
                    order = await strapi.entityService.create("api::order.order", {
                        data: {
                            firstName: body === null || body === void 0 ? void 0 : body.firstName,
                            lastName: body === null || body === void 0 ? void 0 : body.lastName,
                            email: body === null || body === void 0 ? void 0 : body.email,
                            company: body === null || body === void 0 ? void 0 : body.company,
                            sector: (body === null || body === void 0 ? void 0 : body.industry) || "-",
                            designation: body === null || body === void 0 ? void 0 : body.designation,
                            nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "-",
                            residanceCountry: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "-",
                            countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                            mobile: (body === null || body === void 0 ? void 0 : body.phone) || "-",
                            photo: body === null || body === void 0 ? void 0 : body.photo,
                            emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "-",
                            orderId: order_number,
                            type: "myself",
                            eventDate: new Date(),
                            ticketCount: 1,
                            discountAmount: 0,
                            discountCode: null,
                            totalAmount: 0,
                            paidAmount: 0,
                            is_discounted: false,
                            publishedAt: new Date(),
                            utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                            utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                            utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                            utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                            utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                            status: "Free",
                            userType: "onsite",
                        },
                        // transacting: trx,
                    });
                }
                // time formating
                const options = {
                    timeZone: "Asia/Dubai",
                    weekday: "short",
                    year: "numeric",
                    month: "short",
                    day: "2-digit",
                    hour: "2-digit",
                    minute: "2-digit",
                    second: "2-digit",
                    hour12: false,
                };
                const formatter = new Intl.DateTimeFormat("en-US", options);
                const parts = formatter.formatToParts(new Date());
                const formattedDate = `${parts.find(p => p.type === "weekday").value} ${parts.find(p => p.type === "month").value} ${parts.find(p => p.type === "day").value} ${parts.find(p => p.type === "year").value} ${parts.find(p => p.type === "hour").value}:${parts.find(p => p.type === "minute").value}:${parts.find(p => p.type === "second").value}`;
                // ticket data
                let ticketData;
                if (existingTicket) {
                    let ticket = {
                        firstName: body === null || body === void 0 ? void 0 : body.firstName,
                        lastName: body === null || body === void 0 ? void 0 : body.lastName,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        sector: (body === null || body === void 0 ? void 0 : body.industry) || "-",
                        designation: body === null || body === void 0 ? void 0 : body.designation,
                        nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "-",
                        residanceCountry: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "-",
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        mobile: (body === null || body === void 0 ? void 0 : body.phone) || "-",
                        photo: body === null || body === void 0 ? void 0 : body.photo,
                        emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "-",
                        status: "issued",
                        badgeCategory: body === null || body === void 0 ? void 0 : body.badgeCategory,
                        day: day,
                        ticket_id: tiketTypeData === null || tiketTypeData === void 0 ? void 0 : tiketTypeData.id,
                        dayShort: dayShort,
                        notes: `${existingTicket.notes && existingTicket.notes} - Updated by Evento(${formattedDate})`,
                    };
                    ticketData = await strapi.entityService.update("api::ticket-master.ticket-master", existingTicket.id, {
                        data: ticket,
                        populate: {
                            ticket_id: true,
                        },
                        transacting: trx,
                    });
                }
                else {
                    let ticket = {
                        firstName: body === null || body === void 0 ? void 0 : body.firstName,
                        lastName: body === null || body === void 0 ? void 0 : body.lastName,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        sector: (body === null || body === void 0 ? void 0 : body.industry) || "-",
                        designation: body === null || body === void 0 ? void 0 : body.designation,
                        nationality: (body === null || body === void 0 ? void 0 : body.nationality) || "-",
                        residanceCountry: (body === null || body === void 0 ? void 0 : body.residanceCountry) || "-",
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        mobile: (body === null || body === void 0 ? void 0 : body.phone) || "-",
                        photo: body === null || body === void 0 ? void 0 : body.photo,
                        emirate: (body === null || body === void 0 ? void 0 : body.emirate) || "-",
                        badgeCategory: body === null || body === void 0 ? void 0 : body.badgeCategory,
                        day: day,
                        ticket_id: tiketTypeData === null || tiketTypeData === void 0 ? void 0 : tiketTypeData.id,
                        dayShort: dayShort,
                        ticketHolder: "onsite",
                        notes: `Created by Evento(${formattedDate})`,
                        orderId: order === null || order === void 0 ? void 0 : order.id,
                        type: "myself",
                        ticketNumber: body === null || body === void 0 ? void 0 : body.ticketNumber,
                        orderNumber: order === null || order === void 0 ? void 0 : order.orderId,
                        publishedAt: new Date(),
                        paymentStatus: "Free",
                        status: "issued",
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        token: "",
                    };
                    ticketData = await strapi.entityService.create("api::ticket-master.ticket-master", {
                        data: ticket,
                        populate: {
                            ticket_id: true,
                        },
                        transacting: trx,
                    });
                }
                const resData = {
                    ticketNumber: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
                };
                return new dataResponse_dto_1.DataResponseDto(resData, "Success");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async syncTicketsWithEveno(body) {
        var _a, _b;
        try {
            if (!(body === null || body === void 0 ? void 0 : body.ticketData) || (body === null || body === void 0 ? void 0 : body.ticketData.length) === 0) {
                return new dataResponse_dto_1.DataResponseDto("orderIdArray is empty or not provided");
            }
            const placeholders = body.ticketData.map(() => '?').join(',');
            const knex = strapi.db.connection;
            // issued tickets
            const query = `
          SELECT ticket_number,status,first_name,last_name,email,order_number,day_short,ticket_holder,badge_category
          FROM ticket_masters
          WHERE ticket_number NOT IN (${placeholders})
            AND status = 'issued'
          ORDER BY id DESC;
        `;
            const data = await knex.raw(query, body.ticketData);
            // all tickets
            const query2 = `
          SELECT ticket_number,status,first_name,last_name,email,order_number,day_short,ticket_holder,badge_category
          FROM ticket_masters
          WHERE ticket_number NOT IN (${placeholders})
          ORDER BY id DESC;
        `;
            const data2 = await knex.raw(query, body.ticketData);
            return {
                issuedTicktes: {
                    dataCount: ((_a = data === null || data === void 0 ? void 0 : data.rows) === null || _a === void 0 ? void 0 : _a.length) || 0,
                    data: (data === null || data === void 0 ? void 0 : data.rows) || [],
                },
                allTickets: {
                    dataCount: ((_b = data2 === null || data2 === void 0 ? void 0 : data2.rows) === null || _b === void 0 ? void 0 : _b.length) || 0,
                    data: (data2 === null || data2 === void 0 ? void 0 : data2.rows) || [],
                },
                status: true,
                message: "Data fetched successfully",
            };
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllDuplicateTickets(params) {
        try {
            const { page, pageSize, search } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const query = `
        WITH DuplicateTickets AS (
          SELECT 
            tm.id,
            tm.ticket_number,
            tm.status,
            tm.first_name,
            tm.last_name,
            tm.company,
            tm.ticket_holder,
            LOWER(tm.email) as email,
            tm.badge_category,
            tm.day_short,
            tm.created_at,
            t.title as ticket_title,
            t.id_short as ticket_id_short,
            COUNT(*) OVER (PARTITION BY LOWER(tm.email)) as duplicate_count
          FROM ticket_masters tm
          LEFT JOIN ticket_masters_ticket_id_links tmtl ON tm.id = tmtl.ticket_master_id
          LEFT JOIN tickets t ON tmtl.ticket_id = t.id
          WHERE 
            tm.is_deleted = false 
            AND tm.status NOT IN ('refunded', 'cancelled', 'deleted', 'draft')
            ${search ? `AND (LOWER(tm.email) LIKE LOWER('%${search}%'))` : ''}
        )
        SELECT 
          email,
          JSON_AGG(
            JSON_BUILD_OBJECT(
              'id', id,
              'ticket_number', ticket_number,
              'status', status,
              'email', email,
              'first_name', first_name,
              'last_name', last_name,
              'company',company,
              'badge_category', badge_category,
              'day_short', day_short,
              'ticket_title', ticket_title,
              'ticket_id_short', ticket_id_short,
              'ticket_holder', ticket_holder,
              'created_at' , created_at,
              'is_duplicate', duplicate_count > 1
            )
          ) AS duplicates,
          COUNT(*) OVER() as total_count
        FROM DuplicateTickets
        WHERE duplicate_count > 1
        GROUP BY email
        ORDER BY email
        LIMIT ${limit}
        OFFSET ${offset}
        `;
            const { rows } = await strapi.db.connection.raw(query);
            const total = rows.length > 0 ? Number(rows[0].total_count) : 0;
            const totalPages = Math.ceil(total / limit);
            const result = {
                data: rows,
                pagination: {
                    page: pageNumber,
                    pageSize: limit,
                    pageCount: totalPages,
                    total,
                },
            };
            return new dataResponse_dto_1.DataResponseDto(result, "Tickets data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async deleteTicketFromEvento(body) {
        var _a, _b;
        try {
            if (!(body === null || body === void 0 ? void 0 : body.ticketIds) || (body === null || body === void 0 ? void 0 : body.ticketIds.length) === 0) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide required details");
            }
            let successArray = [];
            let failedArray = [];
            for (const element of body === null || body === void 0 ? void 0 : body.ticketIds) {
                let eventoObj = {
                    OrderNumber: "",
                    TicketId: element,
                    Status: 0,
                };
                let url = process.env.EVENTO_UPDATE_STATUS;
                let eventoUpdatedData = await axios.post(url, eventoObj, {
                    headers: {
                        Authorization: process.env.EVENTO_VISITOR_TOKEN,
                        "Content-Type": "application/json",
                    },
                });
                if (((_a = eventoUpdatedData === null || eventoUpdatedData === void 0 ? void 0 : eventoUpdatedData.data) === null || _a === void 0 ? void 0 : _a.Status) === "OK") {
                    successArray.push((_b = eventoUpdatedData === null || eventoUpdatedData === void 0 ? void 0 : eventoUpdatedData.data) === null || _b === void 0 ? void 0 : _b.VisitorNumber);
                }
                else {
                    failedArray.push(element);
                }
            }
            const response = {
                success: {
                    count: successArray.length,
                    data: successArray
                },
                failed: {
                    count: failedArray.length,
                    data: failedArray
                }
            };
            return new dataResponse_dto_1.DataResponseDto(response, "Updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async upgradeTicketStatus(body) {
        var _a, _b, _c;
        try {
            const ticketData = await strapi.db.query("api::ticket-master.ticket-master").findMany({
                where: {
                    is_deleted: false,
                    status: {
                        $in: ["assigned", "reassigned"]
                    },
                    isSyncEvento: false
                },
                populate: {
                    ticket_id: true,
                },
                limit: 500,
                orderBy: { id: "asc" }
            });
            let response = [];
            for (const element of ticketData) {
                await strapi.db.query("api::ticket-master.ticket-master").update({
                    where: { id: element.id, is_deleted: false },
                    data: {
                        isSyncEvento: true
                    }
                });
                let paymentStatus = (element === null || element === void 0 ? void 0 : element.paymentStatus) === "Paid" ? "Paid" : "Foc";
                let URL = process.env.EVENTO_VISITOR_INSERT;
                let reqObj = {
                    OrderNumber: element === null || element === void 0 ? void 0 : element.orderNumber,
                    VisitorNumber: element === null || element === void 0 ? void 0 : element.ticketNumber,
                    FirstName: element === null || element === void 0 ? void 0 : element.firstName,
                    LastName: element === null || element === void 0 ? void 0 : element.lastName,
                    Company: "Null",
                    JobTitle: "Null",
                    Email: element === null || element === void 0 ? void 0 : element.email,
                    Nationality: "United Arab Emirates",
                    BadgeCategory: element === null || element === void 0 ? void 0 : element.badgeCategory,
                    Country: "United Arab Emirates",
                    Mobile: "971 111111111",
                    SingleDay: ((_a = element === null || element === void 0 ? void 0 : element.day) === null || _a === void 0 ? void 0 : _a.event) || "Other",
                    TicketType: (_b = element === null || element === void 0 ? void 0 : element.ticket_id) === null || _b === void 0 ? void 0 : _b.id_short,
                    Sector: "Other",
                    City: "United Arab Emirates",
                    Payment: paymentStatus,
                    Emirate: "Abu Dhabi",
                    Photo: constants_1.IMAGES.GENERIC_PROFILE_IMAGE,
                    Quantiy: 1,
                };
                const eventoRes = await axios.post(URL, reqObj, {
                    headers: {
                        Authorization: process.env.EVENTO_VISITOR_TOKEN,
                        "Content-Type": "application/json",
                    },
                });
                if (((_c = eventoRes === null || eventoRes === void 0 ? void 0 : eventoRes.data) === null || _c === void 0 ? void 0 : _c.Status) === "OK") {
                    response.push({ id: element === null || element === void 0 ? void 0 : element.id, ticketNumber: element === null || element === void 0 ? void 0 : element.ticketNumber });
                }
            }
            return new dataResponse_dto_1.DataResponseDto(response, "Data updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findVisitorDetails(ticketNumber) {
        var _a;
        try {
            let URL = process.env.EVENTO_VISITOR_DETAILS + `?visitorNumber=${ticketNumber}`;
            let visitorData = await axios.get(URL, {
                headers: {
                    Authorization: process.env.EVENTO_VISITOR_TOKEN,
                    "Content-Type": "application/json",
                },
            });
            if (((_a = visitorData === null || visitorData === void 0 ? void 0 : visitorData.data) === null || _a === void 0 ? void 0 : _a.Status) === "OK") {
                return new dataResponse_dto_1.DataResponseDto(visitorData.data, "Visitor details fetched successfully");
            }
            return new dataResponse_dto_1.DataResponseDto(null, "Failed to fetch from Evento");
        }
        catch (error) {
            console.log(error);
            new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async getToken(body) {
        try {
            const secret = process.env.EVENTO_JWT_SECRET;
            const jwtPayload = body;
            const token = jwt.sign(jwtPayload, secret);
            return token;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    }
}));
