"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::ticket.ticket');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/tickets/remove/:id",
        handler: "ticket.softDelete",
        config: {
            policies: [],
            // middlewares: [
            //   {
            //     name: "global::role-access",
            //     config: {
            //       allowedRoles: [1],
            //       policies: [],
            //     },
            //   },
            // ],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
