"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::venture-park-startup.venture-park-startup');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/venture-park-startup/byDate",
        handler: "venture-park-startup.findByDate",
        config: {
            policies: [],
            middlewares: []
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
