"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::venture-park-startup.venture-park-startup", ({ strapi }) => ({
    async findByDate() {
        try {
            let query = `
        SELECT 
        date,
        JSON_AGG(startup ORDER BY priority) AS startups
        FROM (
            SELECT 
                id,
                title,
                description,
                logo,
                sector,
                founders,
                team_members_count,
                headquarters,
                investment_stage,
                funds_raised,
                notable_investors,
                priority,
                date
            FROM venture_park_startups
            WHERE is_deleted = false
        ) AS startup
        GROUP BY date
        ORDER BY date;
        `;
            const data = await strapi.db.connection.raw(query);
            return new dataResponse_dto_1.DataResponseDto(data.rows, "venture-park-startup data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
