"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const moment_1 = __importDefault(require("moment"));
module.exports = {
    async createAppleWalletPass(ctx, next) {
        try {
            const { ticketNumber } = ctx.request.query;
            if (!ticketNumber) {
                return ctx.badRequest("Ticket number is required");
            }
            const data = await strapi
                .service("api::wallets.wallets")
                .createAppleWalletPass(ticketNumber);
            const DTSTAMP = (0, moment_1.default)().unix();
            ctx.set({
                "Content-Type": "application/vnd.apple.pkpass",
                "Content-Disposition": `attachment; filename="adfw-pass-${DTSTAMP}.pkpass"`,
            });
            ctx.body = data;
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async addToGoogleWallet(ctx, next) {
        try {
            const { ticketNumber } = ctx.request.query;
            if (!ticketNumber) {
                return ctx.badRequest("Ticket number is required");
            }
            const data = await strapi
                .service("api::wallets.wallets")
                .addToGoogleWallet(ticketNumber);
            return ctx.response.redirect(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
};
