"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const constants_1 = require("../../../shared/helpers/constants");
const fs = require("fs");
const path = require("path");
const { PKPass } = require("passkit-generator");
const { GoogleAuth } = require("google-auth-library");
const jwt = require("jsonwebtoken");
const httpClient = new GoogleAuth({
    credentials: {
        type: process.env.GOOGLE_WALLET_PROJECT_TYPE,
        project_id: process.env.GOOGLE_WALLET_PROJECT_ID,
        private_key_id: process.env.GOOGLE_WALLET_PRIVATE_KEY_ID,
        private_key: process.env.GOOGLE_WALLET_PRIVATE_KEY.replace(/\\n/g, '\n')
            .replace(/"/g, '')
            .replace(/^"(.*)"$/, '$1'),
        client_email: process.env.GOOGLE_WALLET_CLIENT_EMAIL,
        client_id: process.env.GOOGLE_WALLET_CLIENT_ID,
        auth_uri: process.env.GOOGLE_WALLET_AUTH_URI,
        token_uri: process.env.GOOGLE_WALLET_TOKEN_URI,
        auth_provider_x509_cert_url: process.env.GOOGLE_WALLET_AUTH_PROVIDER_CERT_URL,
        client_x509_cert_url: process.env.GOOGLE_WALLET_CLIENT_CERT_URL,
        universe_domain: process.env.GOOGLE_WALLET_UNIVERSE_DOMAIN
    },
    scopes: "https://www.googleapis.com/auth/wallet_object.issuer",
});
module.exports = {
    createAppleWalletPass: async (ticketNumber) => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        try {
            const ticket = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findOne({
                where: {
                    ticketNumber: ticketNumber,
                    is_deleted: false,
                },
                populate: {
                    ticket_id: true,
                },
            });
            if (!ticket) {
                return new dataResponse_dto_1.DataResponseDto(null, "Ticket not found");
            }
            // Load certificates
            const wwdr = fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "apple-wallet-certificates", "wwdr.pem"));
            const signerCert = fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "apple-wallet-certificates", "signerCert.pem"));
            const signerKey = fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "apple-wallet-certificates", "signerKey.pem"));
            const signerKeyPassphrase = process.env.APPLE_KEY_PASS_PHRASE; // Replace with your actual passphrase
            const pass = new PKPass({
                "icon.png": fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "assets", "icon.png")),
                "pass.json": JSON.stringify({
                    formatVersion: 1,
                    passTypeIdentifier: process.env.PASS_TYPE_IDENTIFIER,
                    teamIdentifier: process.env.PK_PASS_TEAM_IDENTIFIER,
                    serialNumber: process.env.PK_PASS_SERIAL_NUMBER,
                    organizationName: "ADFW",
                    headerFields: "ADFW",
                    description: "Abu Dhabi Finance Week - Welcome to the Capital of Capital",
                    foregroundColor: "rgb(255, 255, 255)",
                    labelColor: "rgb(255, 255, 255)",
                    eventTicket: {
                        headerFields: [
                            {
                                label: "DEC 09-12",
                                key: "gate",
                                value: "2024",
                            },
                        ],
                        primaryFields: [
                            {
                                key: "Event",
                                label: "",
                                value: `${ticket === null || ticket === void 0 ? void 0 : ticket.firstName} ${ticket === null || ticket === void 0 ? void 0 : ticket.lastName}`,
                            },
                        ],
                        secondaryFields: [
                            {
                                key: "location",
                                label: ((_a = ticket === null || ticket === void 0 ? void 0 : ticket.company) === null || _a === void 0 ? void 0 : _a.toUpperCase()) || "",
                                value: (ticket === null || ticket === void 0 ? void 0 : ticket.designation) || "",
                            },
                        ],
                        auxiliaryFields: [
                            {
                                key: "category",
                                label: "CATEGORY",
                                value: ((_c = (_b = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _b === void 0 ? void 0 : _b.event) === null || _c === void 0 ? void 0 : _c.toLowerCase()) === "other"
                                    ? (_d = ticket.ticket_id.title) === null || _d === void 0 ? void 0 : _d.toUpperCase()
                                    : `${(_f = (_e = ticket === null || ticket === void 0 ? void 0 : ticket.ticket_id) === null || _e === void 0 ? void 0 : _e.title) === null || _f === void 0 ? void 0 : _f.toUpperCase()}: ${(_h = (_g = ticket === null || ticket === void 0 ? void 0 : ticket.day) === null || _g === void 0 ? void 0 : _g.event) === null || _h === void 0 ? void 0 : _h.toUpperCase()}`
                            },
                        ],
                        backFields: [
                            {
                                key: "terms",
                                label: "Terms and Conditions",
                                value: "These are the terms and conditions for this event. Please refer to our website for more details.",
                            },
                        ],
                    },
                    relevantDate: "2024-12-30T20:00:00Z",
                    expirationDate: "2024-12-30T23:59:59Z",
                }),
                "it.lproj/pass.strings": Buffer.from(""),
                "logo.png": fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "assets", "logo.png")),
                "background@2x.png": fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "assets", "background@2x.png")),
                "thumbnail.png": fs.readFileSync(path.join(__dirname, "..", "..", "..", "..", "..", "assets", "thumbnail.png")),
            }, {
                wwdr,
                signerCert,
                signerKey,
                signerKeyPassphrase,
            }, {
                serialNumber: process.env.PK_PASS_SERIAL_NUMBER,
                organizationName: process.env.PK_PASS_ORGANIZATION_NAME,
                description: process.env.PK_PASS_DESCRIPTION,
                teamIdentifier: process.env.PK_PASS_TEAM_IDENTIFIER,
                passTypeIdentifier: process.env.PASS_TYPE_IDENTIFIER, // Replace with your Pass Type ID
            });
            pass.setBarcodes({
                message: ticketNumber,
                format: process.env.PASS_BARCODE_FORMAT,
                messageEncoding: process.env.PASS_MESSAGE_ENCODING,
            });
            // Generate the .pkpass file as a buffer
            const buffer = pass.getAsBuffer();
            return buffer;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    addToGoogleWallet: async (ticketNumber) => {
        try {
            await createGooglePassClass();
            const data = await createGooglePassObject(ticketNumber);
            return data;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong on our end. Please contact the system administrator.");
        }
    },
};
const createGooglePassClass2 = async () => {
    const genericClass = {
        id: `${process.env.GOOGLE_WALLET_CLASS_ID}`,
        classTemplateInfo: {
            cardTemplateOverride: {
                cardRowTemplateInfos: [
                    {
                        "oneItem": {
                            "item": {
                                "firstValue": {
                                    "fields": [
                                        {
                                            "fieldPath": "object.textModulesData['company']",
                                        },
                                    ],
                                },
                            },
                        },
                    },
                    {
                        "oneItem": {
                            "item": {
                                "firstValue": {
                                    "fields": [
                                        {
                                            "fieldPath": "object.textModulesData['category']",
                                        },
                                    ],
                                },
                            },
                        },
                    },
                ]
            },
        }
    };
    let response;
    try {
        response = await httpClient.request({
            url: `${process.env.GOOGLE_WALLET_BASE_URL}/genericClass/${process.env.GOOGLE_WALLET_CLASS_ID}`,
            method: "GET",
        });
    }
    catch (err) {
        if (err.response && err.response.status === 404) {
            // Class does not exist
            // Create it now
            response = await httpClient.request({
                url: `${process.env.GOOGLE_WALLET_BASE_URL}/genericClass`,
                method: "POST",
                data: genericClass,
            });
            console.log("Class insert response");
        }
        else {
            console.log(err);
            return new dataResponse_dto_1.DataResponseDto(null, err.message);
        }
    }
};
const createGooglePassObject2 = async (ticketNumber) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    try {
        // Fetch ticket data with type
        const ticketData = await strapi.db
            .query("api::ticket-master.ticket-master")
            .findOne({
            where: {
                ticketNumber,
                status: "issued",
                is_deleted: false,
            },
            select: ["firstName", "lastName", "ticketNumber", "company", "designation", "email", "dayShort"],
            populate: {
                ticket_id: {
                    select: ["title", "id_short"],
                },
            },
        });
        console.log("ticketData==>", ticketData);
        if (!ticketData) {
            return "No ticket found";
        }
        let objectSuffix = `${(_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.email) === null || _a === void 0 ? void 0 : _a.replace(/[^\w.-]/g, "_")}`;
        let objectId = `${process.env.GOOGLE_WALLET_ISSUER_ID}.${objectSuffix}`;
        let genericObject = {
            id: `${objectId}`,
            classId: process.env.GOOGLE_WALLET_CLASS_ID,
            logo: {
                sourceUri: {
                    uri: constants_1.IMAGES.PUSH_NOTIFICATION_IMAGE,
                },
                contentDescription: {
                    defaultValue: {
                        language: "en-US",
                        value: "ADFW Logo",
                    },
                },
            },
            cardTitle: {
                defaultValue: {
                    language: "en-US",
                    value: "DEC 09-12 2024",
                },
            },
            header: {
                defaultValue: {
                    language: "en-US",
                    value: `${ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName} ${ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName}`,
                },
            },
            textModulesData: [
                {
                    "id": "company",
                    "header": (_b = ticketData === null || ticketData === void 0 ? void 0 : ticketData.company) === null || _b === void 0 ? void 0 : _b.toUpperCase(),
                    "body": (_c = ticketData === null || ticketData === void 0 ? void 0 : ticketData.designation) === null || _c === void 0 ? void 0 : _c.toUpperCase(),
                },
                {
                    "id": "category",
                    "header": "CATEGORY",
                    "body": ((_e = (_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _d === void 0 ? void 0 : _d.event) === null || _e === void 0 ? void 0 : _e.toLowerCase()) === "other"
                        ? (_f = ticketData.ticket_id.title) === null || _f === void 0 ? void 0 : _f.toUpperCase()
                        : `${(_h = (_g = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _g === void 0 ? void 0 : _g.title) === null || _h === void 0 ? void 0 : _h.toUpperCase()}: ${(_k = (_j = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _j === void 0 ? void 0 : _j.event) === null || _k === void 0 ? void 0 : _k.toUpperCase()}`,
                },
            ],
            barcode: {
                type: "QR_CODE",
                value: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
                alternateText: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
            },
            hexBackgroundColor: "#0e3a81",
            linksModuleData: {
                uris: [
                    {
                        uri: "https://www.adfw.com",
                        description: "Visit ADFW Website",
                        id: "website",
                    }
                ],
            }
        };
        // Create the signed JWT and link
        const claims = {
            iss: process.env.GOOGLE_WALLET_CLIENT_EMAIL,
            aud: "google",
            origins: [],
            typ: "savetowallet",
            payload: {
                genericObjects: [genericObject],
            },
        };
        const token = jwt.sign(claims, process.env.GOOGLE_WALLET_PRIVATE_KEY.replace(/\\n/g, '\n').replace(/"/g, '').replace(/^"(.*)"$/, '$1'), {
            algorithm: "RS256",
        });
        const saveUrl = `https://pay.google.com/gp/v/save/${token}`;
        return saveUrl;
    }
    catch (error) {
        console.log(error);
        return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
    }
};
const createGooglePassClass = async () => {
    const genericClass = {
        id: `${process.env.GOOGLE_WALLET_CLASS_ID}`,
        "classTemplateInfo": {
            "cardTemplateOverride": {
                "cardRowTemplateInfos": [
                    {
                        "twoItems": {
                            "startItem": {
                                "firstValue": {
                                    "fields": [
                                        {
                                            "fieldPath": "object.textModulesData['company']",
                                        },
                                    ],
                                },
                            },
                            "endItem": {
                                "firstValue": {
                                    "fields": [
                                        {
                                            "fieldPath": "object.textModulesData['date']",
                                        },
                                    ],
                                },
                            },
                        },
                    },
                    {
                        "oneItem": {
                            "item": {
                                "firstValue": {
                                    "fields": [
                                        {
                                            "fieldPath": "object.textModulesData['category']",
                                        },
                                    ],
                                },
                            },
                        },
                    },
                ],
            },
        },
    };
    let response;
    try {
        response = await httpClient.request({
            url: `${process.env.GOOGLE_WALLET_BASE_URL}/genericClass/${process.env.GOOGLE_WALLET_CLASS_ID}`,
            method: "GET",
        });
    }
    catch (err) {
        if (err.response && err.response.status === 404) {
            // Class does not exist
            // Create it now
            response = await httpClient.request({
                url: `${process.env.GOOGLE_WALLET_BASE_URL}/genericClass`,
                method: "POST",
                data: genericClass,
            });
            console.log("Class insert response");
        }
        else {
            console.log(err);
            return new dataResponse_dto_1.DataResponseDto(null, err.message);
        }
    }
};
const createGooglePassObject = async (ticketNumber) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    try {
        // Fetch ticket data with type
        const ticketData = await strapi.db
            .query("api::ticket-master.ticket-master")
            .findOne({
            where: {
                ticketNumber,
                status: "issued",
                is_deleted: false,
            },
            select: ["firstName", "lastName", "ticketNumber", "company", "designation", "email", "dayShort"],
            populate: {
                ticket_id: {
                    select: ["title", "id_short"],
                },
            },
        });
        if (!ticketData) {
            return "No ticket found";
        }
        let objectSuffix = `${(_a = ticketData === null || ticketData === void 0 ? void 0 : ticketData.email) === null || _a === void 0 ? void 0 : _a.replace(/[^\w.-]/g, "_")}`;
        let objectId = `${process.env.GOOGLE_WALLET_ISSUER_ID}.${objectSuffix}`;
        let genericObject = {
            id: `${objectId}`,
            classId: process.env.GOOGLE_WALLET_CLASS_ID,
            logo: {
                sourceUri: {
                    uri: constants_1.IMAGES.PUSH_NOTIFICATION_IMAGE
                },
                contentDescription: {
                    defaultValue: {
                        language: "en-US",
                        value: "ADFW Logo",
                    }
                }
            },
            cardTitle: {
                defaultValue: {
                    language: "en-US",
                    value: "ADFW"
                }
            },
            header: {
                defaultValue: {
                    language: "en-US",
                    value: `${ticketData === null || ticketData === void 0 ? void 0 : ticketData.firstName} ${ticketData === null || ticketData === void 0 ? void 0 : ticketData.lastName}`,
                },
            },
            textModulesData: [
                {
                    id: "company",
                    header: (_b = ticketData === null || ticketData === void 0 ? void 0 : ticketData.company) === null || _b === void 0 ? void 0 : _b.toUpperCase(),
                    body: (_c = ticketData === null || ticketData === void 0 ? void 0 : ticketData.designation) === null || _c === void 0 ? void 0 : _c.toUpperCase()
                },
                {
                    id: "date",
                    header: "DEC 09-12",
                    body: "2024",
                },
                {
                    id: "category",
                    header: "CATEGORY",
                    body: ((_e = (_d = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _d === void 0 ? void 0 : _d.event) === null || _e === void 0 ? void 0 : _e.toLowerCase()) === "other"
                        ? (_f = ticketData.ticket_id.title) === null || _f === void 0 ? void 0 : _f.toUpperCase()
                        : `${(_h = (_g = ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticket_id) === null || _g === void 0 ? void 0 : _g.title) === null || _h === void 0 ? void 0 : _h.toUpperCase()}: ${(_k = (_j = ticketData === null || ticketData === void 0 ? void 0 : ticketData.day) === null || _j === void 0 ? void 0 : _j.event) === null || _k === void 0 ? void 0 : _k.toUpperCase()}`,
                },
            ],
            barcode: {
                type: "QR_CODE",
                value: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
                alternateText: ticketData === null || ticketData === void 0 ? void 0 : ticketData.ticketNumber,
            },
            hexBackgroundColor: "#0e3a81",
            linksModuleData: {
                uris: [
                    {
                        uri: "https://www.adfw.com",
                        description: "Visit ADFW Website",
                        id: "website",
                    }
                ],
            }
        };
        // Create the signed JWT and link
        const claims = {
            iss: process.env.GOOGLE_WALLET_CLIENT_EMAIL,
            aud: "google",
            origins: [],
            typ: "savetowallet",
            payload: {
                genericObjects: [genericObject],
            },
        };
        const token = jwt.sign(claims, process.env.GOOGLE_WALLET_PRIVATE_KEY.replace(/\\n/g, '\n').replace(/"/g, '').replace(/^"(.*)"$/, '$1'), {
            algorithm: "RS256",
        });
        const saveUrl = `https://pay.google.com/gp/v/save/${token}`;
        return saveUrl;
    }
    catch (error) {
        console.log(error);
        return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
    }
};
