module.exports = {
  async createInvoice(ctx:any) {
    try {
      const { orderId } = ctx.params;

      // Get order from DB
      const orderData = await strapi.db.query("api::order.order").findOne({
        where: { orderId, is_deleted: false },
      });

      if (!orderData) {
        return ctx.send({
          success: false,
          message: "Order not found",
        });
      }

      // Pass order data into invoice generator
      const fileUrl = await strapi
        .service("api::invoice.invoice")
        .generateInvoice(orderData);

      ctx.send({
        success: true,
        message: "Invoice generated successfully",
        url: fileUrl,
      });
    } catch (err) {
      ctx.throw(500, err);
    }
  },
};
