module.exports = (orderData) => {
  return `
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8"/>
  <title>Invoice ${orderData.orderId}</title>
</head>
<body style="margin:0;padding:20px;background:#ffffff;font-family:Arial,sans-serif;font-size:12px;color:#000;">
  <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">

    <!-- Header -->
    <tr>
      <td style="padding:15px;">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td align="center">
              <img src="https://www.adfw.com/assets/img/logo.png" alt="Logo" style="max-width:200px;"><br>
            </td>
          </tr>
        </table>
      </td>
    </tr>

    <!-- Info Block -->
    <tr>
      <td style="padding:15px 0; border-bottom:1px solid #000;">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top" width="50%">
              <p style="margin:5px 0;">Tax Invoice No: ${orderData.orderId}</p>
              <p style="margin:5px 0;">Date: ${new Date(orderData.createdAt).toLocaleString()}</p>
              <p style="margin:5px 0;">TRN #: 100212456600003</p>
              <p style="margin:5px 0;">Event Name: Abu Dhabi Finance Week</p>
              <p style="margin:5px 0;">Event Date: ${orderData.eventDate}</p>
            </td>
          </tr>
          <tr>
            <td valign="top" width="50%">
              <br><br>
              <p style="margin:5px 0;">Bill To:</p>
              <p style="margin:5px 0;">Delegate Name: ${orderData.firstName} ${orderData.lastName}</p>
              <p style="margin:5px 0;">Country: ${orderData.residanceCountry}</p>
              <p style="margin:5px 0;">Mobile: ${orderData.countryCode} ${orderData.mobile}</p>
              <p style="margin:5px 0;">Email: ${orderData.email}</p>
              ${orderData.company ? `<p style="margin:5px 0;">Company: ${orderData.company}</p>` : ""}
              ${orderData.designation ? `<p style="margin:5px 0;">Designation: ${orderData.designation}</p>` : ""}
            </td>
          </tr>
        </table>
      </td>
    </tr>

    <!-- Items Table -->
    <tr>
      <td style="padding:0;">
        <table width="100%" border="1" cellspacing="0" cellpadding="6" style="border-collapse:collapse;text-align:center;font-size:12px;">
          <tr>
            <td>No</td>
            <td>Item Description</td>
            <td>Qty</td>
            <td>UOM</td>
            <td>Amount (USD)</td>
            <td>VAT%</td>
            <td>VAT Amount (USD)</td>
            <td>Total Amount (USD)</td>
          </tr>
          <tr>
            <td>1</td>
            <td>Registration Fee - Abu Dhabi Finance Week</td>
            <td>${orderData.ticketCount}</td>
            <td>EA</td>
            <td>${(orderData.totalAmount / 1.05).toFixed(2)}</td>
            <td>5.00</td>
            <td>${(orderData.totalAmount - orderData.totalAmount / 1.05).toFixed(2)}</td>
            <td>${orderData.totalAmount.toFixed(2)}</td>
          </tr>
          <tr>
            <td colspan="7" align="left">Total in USD</td>
            <td>${orderData.totalAmount.toFixed(2)}</td>
          </tr>
          <tr>
            <td colspan="8" align="left">Amount in words (USD): ${orderData.amountInWords}</td>
            </tr>
        </table>
      </td>
    </tr>

    <!-- Footer -->
    <tr>
      <td style="padding:15px 0; border-top:1px solid #000;">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td style="font-size:11px; color:#555;">
              This electronically generated document does not require any signature or stamp.
              <br><br>
              In case of any queries, kindly contact us on 
              <a href="mailto:support@adfw.com" style="color:#000; text-decoration:none;">support@adfw.com</a>.
              <br><br><br><br>
            </td>
          </tr>
        </table>
      </td>
    </tr>

  </table>
</body>
</html>
`;
};
