module.exports = {
  createStripePaymentIntent: async (ctx) => {
    try {
      const data = await strapi
        .service("api::payment-gateway.payment-gateway")
        .createStripePaymentIntent(ctx.request.body);
      return ctx.send(data);
    } catch (error) {
      console.log(error);
    }
  },
  confirmStripePayment: async (ctx) => {
    try {
      const data = await strapi
        .service("api::payment-gateway.payment-gateway")
        .confirmStripePayment(ctx.request.body);
      return ctx.send(data);
    } catch (error) {
      console.log(error);
    }
  },
  createStripePaymentLink: async (ctx) => {
    try {
      const data = await strapi
        .service("api::payment-gateway.payment-gateway")
        .createStripePaymentLink(ctx.request.body);
      return ctx.send(data);
    } catch (error) {
      console.log(error);
    }
  },
 retrieveSession: async (ctx) => {
  try {
    const { sessionId } = ctx.params;
    if (!sessionId) {
      return ctx.badRequest("Session ID is required");
    }

    // Directly pass the plain session ID to service
    const data = await strapi
      .service("api::payment-gateway.payment-gateway")
      .retrieveSession(sessionId);

    return ctx.send(data);
  } catch (error) {
    console.error(error);
    return ctx.badRequest("An error occurred while retrieving the session.");
  }
},
};
