import { DataResponseDto } from "../../../shared/dto/dataResponse.dto";
const axios = require("axios");
const jwt = require("jsonwebtoken");

const stripe = require("stripe")(process.env.STRIPE_SECRET_KEY_TEST);

module.exports = {
  async createStripePaymentIntent(body: any) {
    try {
      if (body.amount && body.currency) {
        const paymentIntent = await stripe.paymentIntents.create({
          amount: Number(body.amount) * 100,
          currency: body?.currency.toLowerCase(),
          automatic_payment_methods: {
            enabled: true,
            allow_redirects: "never",
          },
        });

        // await strapi.entityService.create("api::payment-log.payment-log", {
        //   data: {
        //     paymentId: paymentIntent.id,
        //     amount: paymentIntent.amount,
        //     publishedAt: new Date(),
        //   },
        // });

        console.log(paymentIntent,'paymentIntent111');
        return new DataResponseDto(
          paymentIntent,
          "payment intent created successfully"
        );
      } else {
        return new DataResponseDto(null, "amount and currency not found");
      }
    } catch (error) {
      console.log(error);
      return new DataResponseDto(
        null,
        "Something went wrong in our end please contact system administrator"
      );
    }
  },

  async confirmStripePayment(body: any) {
    try {
      if (!body.paymentIntentId) {
        return new DataResponseDto(null, "payment intent id not found");
      }

      const confirmation = await stripe.paymentIntents.retrieve(
        body.paymentIntentId
      );

      // const updatedPaymentLog = await strapi.db
      //   .query("api::payment-log.payment-log")
      //   .update({
      //     where: {
      //       paymentId: body.paymentIntentId,
      //     },
      //     data: {
      //       status: confirmation.status,
      //       details: confirmation,
      //     },
      //   });

      if (confirmation.status !== "succeeded") {
        return new DataResponseDto(confirmation, "payment failed");
      }
      return new DataResponseDto(
        confirmation,
        "payment confirmed successfully"
      );
    } catch (error) {
      console.log(error);
      return new DataResponseDto(
        null,
        "Something went wrong in our end please contact system administrator"
      );
    }
  },
  async createStripePaymentLink(body: any): Promise<any> {
    try {
      const { amount, currency, quantity, ticketName, orderNumber, type } = body;
      if (!amount || !currency || !quantity) {
        return new DataResponseDto(null, "amount or currency is not provided");
      }

      console.log('orderNumber=',orderNumber);
      if(!orderNumber || !type){
        return new DataResponseDto(null, "Order Number and type must be required");
      }

       const orderData = await strapi.db.query("api::order.order").findOne({
            where: { orderId: orderNumber, is_deleted: false },
          });

        if(!orderData){
        return new DataResponseDto(null, "Order not found");
      }
      

      const lineItems = [
        {
          price_data: {
            currency: currency.toLowerCase(),
            product_data: {
              name: ticketName,
            },
            unit_amount: amount * 100,
          },
          quantity: quantity,
        },
        //   {
        //     price_data: {
        //       currency: currency.toLowerCase(),
        //       product_data: {
        //           name: "Service Charge"
        //       },
        //       unit_amount: 1
        //   },
        //   quantity: 1
        // },
      ];

      let successUrl = "";
    let cancelUrl = "";

    if (type == "myself") {
      successUrl = `${process.env.STRIPE_SUCCESS_URL}?session_id={CHECKOUT_SESSION_ID}&payment_status=success&order_number=${orderNumber}`;
      cancelUrl = `${process.env.STRIPE_CANCEL_URL}?session_id={CHECKOUT_SESSION_ID}&payment_status=cancelled&order_number=${orderNumber}`;
    } else {
      successUrl = `${process.env.STRIPE_SUCCESS_URL_OTHERS}?session_id={CHECKOUT_SESSION_ID}&payment_status=success&order_number=${orderNumber}`;
      cancelUrl = `${process.env.STRIPE_CANCEL_URL_OTHERS}?session_id={CHECKOUT_SESSION_ID}&payment_status=cancelled&order_number=${orderNumber}`;
    }

      const checkoutData = await stripe.checkout.sessions.create({
        payment_method_types: ["card"],
        currency: currency,
        mode: "payment",
        success_url: successUrl,
        cancel_url: cancelUrl,
        line_items: lineItems,
      });

      // console.log('checkoutData=',checkoutData);

              if (checkoutData.url) {
            // Check if entry already exists for same orderId
            const existingLog = await strapi.db.query("api::payment-log.payment-log").findOne({
              where: { orderId: orderNumber },
            });

            if (existingLog) {
              // Update the existing log
              await strapi.entityService.update("api::payment-log.payment-log", existingLog.id, {
                data: {
                  paymentId: checkoutData.id,
                  amount: checkoutData.amount_total,
                  publishedAt: new Date(),
                },
              });
            } else {
              // Create new log
              await strapi.entityService.create("api::payment-log.payment-log", {
                data: {
                  orderId: orderNumber,
                  paymentId: checkoutData.id,
                  amount: checkoutData.amount_total,
                  publishedAt: new Date(),
                },
              });
            }
          }

      return new DataResponseDto(
        checkoutData.url,
        "Link created successfully!"
      );
    } catch (error) {
      console.error("Error =====>:", error);
      return new DataResponseDto(
        null,
        "Something went wrong in our end please contact system administrator"
      );
    }
  },

  async retrieveSessionBKP(sessionId: string) {
    try {
      const session = await stripe.checkout.sessions.retrieve(sessionId);

      if(session.payment_status=="paid"){
      await strapi.db.query("api::payment-log.payment-log").update({
        where: {
          paymentId: sessionId,
        },
        data: {
          status: "succeeded",
          details: session,
        },
      });
    }else{
       return new DataResponseDto(
        { payment_status: session.payment_status },
        "unsuccessfully retrieved!"
      );
    }

      // const log = await strapi.db.query("api::payment-log.payment-log").findOne({
      //   where: { paymentId: sessionId },
      // });
      // console.log("Payment Log Found:", log);

      // console.log('session data=',session);

      return new DataResponseDto(
        { payment_status: session.payment_status },
        "successfully retrieved!"
      );
    } catch (error) {
      console.log(error);
      return new DataResponseDto(
        null,
        "Something went wrong in our end please contact system administrator"
      );
    }
  },

async retrieveSession(sessionId: string) {
  try {
    const session = await stripe.checkout.sessions.retrieve(sessionId);

    if (session.payment_status === "paid") {
      // ✅ Update payment log

              const existingLog = await strapi.db
            .query("api::payment-log.payment-log")
            .findOne({
              where: {
                paymentId: sessionId,
                isEmailSent: true,
                status: "succeeded",
              },
            });

          if (existingLog) {
            return new DataResponseDto(
              { payment_status: session.payment_status },
              "Payment already succeeded and email has been sent."
            );
          }

      const updateData = await strapi.db
        .query("api::payment-log.payment-log")
        .update({
          where: { paymentId: sessionId },
          data: { status: "succeeded", details: session, isEmailSent:true },
        });


      const ticketData = await strapi.db
        .query("api::ticket-master.ticket-master")
        .findOne({
          where: { orderNumber: updateData.orderId, is_deleted: false },
          populate: { day: true, ticket_id: true },
        });

      if (!ticketData) {
        return new DataResponseDto(
          { payment_status: session.payment_status },
          "No ticket found!"
        );
      }

      if (ticketData.type === "myself") {
        await strapi.db.query("api::ticket-master.ticket-master").update({
          where: { ticketNumber: ticketData.ticketNumber },
          data: { status: "issued" },
        });
      }


       const orderData = await strapi.db
        .query("api::order.order")
        .findOne({
          where: { orderId: updateData.orderId, is_deleted: false },
           populate: {
            discountCode: true,
          },
        });

        // console.log('orderData=',orderData);
        if(orderData.discountCode){
           const checkDis=   await strapi
            .service("api::discount-code.discount-code")
            .updateDiscountCodeCount(orderData.discountCode.id);
            // console.log('checkDis=',checkDis);
        }
        
      // Send mail after payment success
       await this.sendTicketEmail(updateData.orderId);

         await this.sendInvoiceEmailAttechedInvoice(updateData.orderId);

      return new DataResponseDto(
        { payment_status: session.payment_status },
        "successfully retrieved!"
      );
    } else {
      return new DataResponseDto(
        { payment_status: session.payment_status },
        "unsuccessfully retrieved!"
      );
    }
  } catch (error) {
    console.log("Error in retrieveSession:", error);
    return new DataResponseDto(
      null,
      "Something went wrong in our end please contact system administrator"
    );
  }
},

async sendTicketEmail(orderNumber: string) {
  try {
    // ✅ Single ticket fetch (for mail data)
    const ticketData = await strapi.db
      .query("api::ticket-master.ticket-master")
      .findOne({
        where: { orderNumber, is_deleted: false },
        populate: { day: true, ticket_id: true }, 
      });

    if (!ticketData) {
      console.error("No ticket found for orderNumber:", orderNumber);
      return false;
    }

   

    // ✅ All tickets count for same order
    const allTickets = await strapi.db
      .query("api::ticket-master.ticket-master")
      .findMany({
        where: { orderNumber, is_deleted: false },
      });
    const ticketCount = allTickets.length;

    const mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;

    // Ticket Type
    const ticketTypeShort = ticketData?.ticket_id?.id_short;
    let ticketTypeTitle = ticketData?.ticket_id?.title || "";

    // Template selection
    let templateName = "";
    if (ticketData.type === "myself") {
      if (ticketTypeShort === "single_day_delegate") {
        templateName = process.env.BUY_FOR_MYSELF_TEMPLATE_NAME;
        ticketTypeTitle =
          ticketData?.ticket_id?.title && ticketData?.day?.event
            ? `${ticketData.ticket_id.title} - ${ticketData.day.event}`
            : ticketData?.ticket_id?.title || "";
      } else if (ticketTypeShort === "delegate") {
        templateName = process.env.BUY_FOR_MYSELF_TEMPLATE_NAME;
      } else if (ticketTypeShort === "executive") {
        templateName = process.env.BUY_FOR_MYSELF_TEMPLATE_NAME_EXECUTIVE;
      } else if (ticketTypeShort === "general_admission") {
        templateName = process.env.BUY_FOR_MYSELF_TEMPLATE_NAME_RESOLVE;
      }
    } else {
      if (ticketTypeShort === "single_day_delegate") {
        templateName = process.env.BUY_FOR_OTHERS_TEMPLATE_NAME;
        ticketTypeTitle =
          ticketData?.ticket_id?.title && ticketData?.day?.event
            ? `${ticketData.ticket_id.title} - ${ticketData.day.event}`
            : ticketData?.ticket_id?.title || "";
      } else if (ticketTypeShort === "delegate") {
        templateName = process.env.BUY_FOR_OTHERS_TEMPLATE_NAME;
      } else if (ticketTypeShort === "executive") {
        templateName = process.env.BUY_FOR_OTHERS_TEMPLATE_NAME_EXECUTIVE;
      } else if (ticketTypeShort === "general_admission") {
        templateName = process.env.BUY_FOR_OTHERS_TEMPLATE_NAME_RESOLVE;
      }
    }

    //  console.log('ticketData',ticketData);
    //  console.log('ticketTypeTitle=',ticketTypeTitle);
    // return true

    // Common merge vars
    let mergeVars: any[] = [
      { name: "FIRSTNAME", content: ticketData?.firstName },
      {
        name: "FULLNAME",
        content: `${ticketData?.firstName} ${ticketData?.lastName}`,
      },
      { name: "EMAIL", content: ticketData?.email },
      { name: "TICKETTYPE", content: ticketTypeTitle },
      { name: "ORDERID", content: ticketData?.orderNumber },
      {
        name: "HIDEREFUNDS",
        content: ticketData?.paymentStatus === "Paid" ? null : true,
      },
    ];

    // Myself → add ticketId + download links
    if (ticketData.type === "myself") {
      mergeVars.push(
        { name: "TICKETID", content: ticketData?.ticketNumber },
        {
          name: "DOWNLOADTICKET",
          content: `${process.env.WEB_URL}ticket-download?ticketNumber=${ticketData?.ticketNumber}`,
        },
        {
          name: "APPLEWALLET",
          content: `${process.env.SERVER_URL}apple-wallet/download-pass?ticketNumber=${ticketData?.ticketNumber}`,
        },
        {
          name: "GOOGLEWALLET",
          content: `${process.env.SERVER_URL}wallet/google-wallet?ticketNumber=${ticketData?.ticketNumber}`,
        },
        { name: "HIDEREFUNDS", content: false }
      );
    }

    // Others → add lastname + dynamic ticket count + manage ticket link
    if (ticketData.type === "others") {
      mergeVars.push(
        { name: "LASTNAME", content: ticketData?.lastName },
        { name: "TICKETCOUNT", content: ticketCount },
        { name: "HIDEREFUNDS", content: true },
        {
          name: "MANAGETICKET",
          content: `${process.env.WEB_URL}ticketing?jwt=${ticketData?.token}`,
        }
      );
    }

    // Mandrill payload
    const obj = {
      key: process.env.MANDRILL_KEY,
      template_name: templateName,
      template_content: [],
      message: {
        to: [
          {
            email: ticketData?.email,
            name: ticketData?.firstName,
            type: "to",
          },
        ],
        from_email: "donotreply@adfw.com",
        from_name: "Abu Dhabi Finance Week",
        global_merge_vars: mergeVars,
      },
    };

    // ✅ Send mail
    const res = await axios.post(mandrilURL, obj);

    console.log(
      `✅ Mail sent for order: ${orderNumber}, Tickets: ${ticketCount}`
    );
    return res.data;
  } catch (err) {
    console.error("❌ Error sending mail:", err);
    return false;
  }
},

//  async sendInvoiceEmail(orderId: string) {
//     try {
//       // 1. Order data fetch from DB
//       const orderData = await strapi.db.query("api::order.order").findOne({
//         where: { orderId, is_deleted: false },
//         populate: { tickets: { populate: { day: true, ticket_id: true } } },
//       });

//       if (!orderData) {
//         console.error("No order found for orderId:", orderId);
//         return false;
//       }

//       // 2. Invoice generate & get file URL
//       const fileUrl = await strapi
//         .service("api::invoice.invoice")
//         .generateInvoice(orderData);

//         if(fileUrl){
//            await strapi.db.query("api::order.order").update({
//             where: { id: orderData.id },
//             data: {
//               invoice_link:fileUrl,
//             },
//             });
//         }

//       // 3. Mandrill API details
//       const mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
//       const templateName = process.env.INVOICE_TEMPLETE_NAME;

//       // 4. Merge Vars
//       const mergeVars: any[] = [
//         { name: "FIRSTNAME", content: orderData.firstName },
//         { name: "INVOICELINK", content: fileUrl },
//       ];

//       // 5. Mandrill payload
//       const obj = {
//         key: process.env.MANDRILL_KEY,
//         template_name: templateName,
//         template_content: [],
//         message: {
//           to: [
//             {
//               email: orderData.email,
//               name: orderData.firstName,
//               type: "to",
//             },
//           ],
//           from_email: "donotreply@adfw.com",
//           from_name: "AbuDhabiFinanceWeek",
//           global_merge_vars: mergeVars,
//         },
//       };

//       // 6. Send email
//       const res = await axios.post(mandrilURL, obj);
//       console.log(` Invoice email sent for order: ${orderId}`);
//       return res.data;
//     } catch (err) {
//       console.error("Error sending invoice email:", err.message);
//       return false;
//     }
//   },

  async sendInvoiceEmailAttechedInvoice(orderId: string) {
  try {
    // 1. Order data fetch from DB
    const orderData = await strapi.db.query("api::order.order").findOne({
      where: { orderId, is_deleted: false },
      populate: {
        tickets: { populate: { day: true, ticket_id: true } },
      },
    });

    if (!orderData) {
      console.error("No order found for orderId:", orderId);
      return false;
    }

    // 2. Invoice generate & get file URL
    const fileUrl = await strapi.service("api::invoice.invoice").generateInvoice(orderData);

    if (fileUrl) {
      await strapi.db.query("api::order.order").update({
        where: { id: orderData.id },
        data: { invoice_link: fileUrl },
      });
    }

    // 3. Fetch PDF file as base64
    const pdfRes = await axios.get(fileUrl, { responseType: "arraybuffer" });
    const pdfBase64 = Buffer.from(pdfRes.data, "binary").toString("base64");

    // 4. Mandrill API details
    const mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
    const templateName = process.env.INVOICE_TEMPLETE_NAME;

    // 5. Merge Vars
    const mergeVars: any[] = [
      { name: "FIRSTNAME", content: orderData.firstName },
      { name: "INVOICELINK", content: fileUrl },
    ];

    // 6. Mandrill payload with attachment
    const obj = {
      key: process.env.MANDRILL_KEY,
      template_name: templateName,
      template_content: [],
      message: {
        to: [
          {
            email: orderData.email,
            name: orderData.firstName,
            type: "to",
          },
        ],
        from_email: "donotreply@adfw.com",
        from_name: "AbuDhabiFinanceWeek",
        global_merge_vars: mergeVars,
        attachments: [
          {
            type: "application/pdf",
            name: `Invoice-${orderId}.pdf`,
            content: pdfBase64,
          },
        ],
      },
    };

    // 7. Send email
    const res = await axios.post(mandrilURL, obj);
    console.log(`Invoice email sent with attachment for order: ${orderId}`);
    return res.data;
  } catch (err: any) {
    console.error("Error sending invoice email:", err.message);
    return false;
  }
}

};
