import { factories } from "@strapi/strapi";

export default factories.createCoreController(
  "api::speaker.speaker",
  ({ strapi }) => ({
    findAllSpeakers: async (ctx) => {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .findAllSpeakers(ctx.request.query);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    findExportData: async (ctx) => {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .findExportData();
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    picker: async (ctx) => {
      try {
        const { query } = ctx.request.query;
        const data = await strapi
          .service("api::speaker.speaker")
          .picker(query);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    latestSpeakers: async (ctx) => {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .latestSpeakers();
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    softDelete: async (ctx) => {
      const { id } = ctx.params;
      if (!id) {
        return ctx.badRequest("ID is required");
      }
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .softDelete(id);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    speakerLogin: async (ctx) => {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .speakerLogin(ctx.request.body);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
      }
    },
    async updateSpeakerTicketDetails(ctx: any, next: any) {
      try {
        const { id } = ctx.params;
        if (!id) {
          return ctx.badRequest("ID is required");
        }
        const data = await strapi
          .service("api::speaker.speaker")
          .updateSpeakerTicketDetails(id, ctx.request.body);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
        return error;
      }
    },
    async createSpeaker(ctx: any, next: any) {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .createSpeaker(ctx.request.body);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
        return error;
      }
    },
    async bulkCreateSpeakers(ctx: any, next: any) {
      try {
        const data = await strapi
          .service("api::speaker.speaker")
          .bulkCreateSpeakers(ctx.request.body);
        return ctx.send(data);
      } catch (error) {
        console.log(error);
        return error;
      }
    },
  })
);
